/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntListIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.AssertException;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ObjectKeyIndexer<T> {
    private static final int DEFAULT_CAPACITY = 13;
    private T[] keys;
    private IntListIndexer indexer;
    private int capacity;

    public ObjectKeyIndexer() {
        this(13);
    }

    public ObjectKeyIndexer(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntListIndexer(capacity, capacity);
        this.keys = new Object[capacity];
    }

    public int put(T key) {
        int index = this.findKey(key);
        if (index == -1) {
            int hashcode;
            if (this.indexer.getSize() >= this.capacity) {
                this.grow();
            }
            if ((index = this.indexer.add(hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity)) < 0) {
                throw new IndexOutOfBoundsException("Maximum capacity reached");
            }
            this.keys[index] = key;
        }
        return index;
    }

    public int get(Object key) {
        return this.findKey(key);
    }

    public int remove(Object key) {
        int index = this.findKey(key);
        if (index == -1) {
            return -1;
        }
        int hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
        this.indexer.remove(hashcode, index);
        return index;
    }

    public int getSize() {
        return this.indexer.getSize();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void clear() {
        this.indexer.clear();
        Arrays.fill(this.keys, null);
    }

    public T[] getKeys(T[] keyArray) {
        int size = this.getSize();
        if (keyArray.length != size) {
            keyArray = (Object[])Array.newInstance(keyArray.getClass().getComponentType(), size);
        }
        int pos = 0;
        int nLists = this.indexer.getNumLists();
        for (int i = 0; i < nLists; ++i) {
            int keyIndex = this.indexer.first(i);
            while (keyIndex >= 0) {
                keyArray[pos++] = this.keys[keyIndex];
                keyIndex = this.indexer.next(keyIndex);
            }
        }
        if (pos != this.getSize()) {
            throw new AssertException("Trouble in IntKeyIndexer.getKeys(), size = " + this.getSize() + "  pos= " + pos);
        }
        return keyArray;
    }

    private int findKey(Object key) {
        int hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
        int p = this.indexer.first(hashcode);
        while (p != -1) {
            if (this.keys[p].equals(key)) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }

    private void grow() {
        int newCapacity = Prime.nextPrime(this.indexer.getNewCapacity());
        this.indexer.growCapacity(newCapacity);
        this.indexer.growNumLists(newCapacity);
        this.indexer.clear();
        T[] oldKeys = this.keys;
        this.keys = new Object[newCapacity];
        this.capacity = newCapacity;
        for (int i = 0; i < oldKeys.length; ++i) {
            this.put(oldKeys[i]);
        }
    }
}

