/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class EditDataTypeAction
extends AbstractDecompilerAction {
    public EditDataTypeAction() {
        super("Edit Data Type");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionEditDataType"));
        this.setPopupMenuData(new MenuData(new String[]{"Edit Data Type"}, "Decompile"));
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    private boolean hasCustomEditorForBaseDataType(PluginTool tool, DataType dataType) {
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        return baseDataType != null && service.isEditable(baseDataType);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DataType dataType = DecompilerUtils.getDataType(context);
        if (dataType == null) {
            return false;
        }
        return this.hasCustomEditorForBaseDataType(context.getTool(), dataType);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DataType dataType = DecompilerUtils.getDataType(context);
        DataType baseDataType = DataTypeUtils.getBaseDataType((DataType)dataType);
        ProgramBasedDataTypeManager dataTypeManager = context.getProgram().getDataTypeManager();
        DataTypeManager baseDtDTM = baseDataType.getDataTypeManager();
        if (baseDtDTM != dataTypeManager) {
            baseDataType = baseDataType.clone((DataTypeManager)dataTypeManager);
        }
        DataTypeManagerService service = (DataTypeManagerService)context.getTool().getService(DataTypeManagerService.class);
        if (dataType instanceof Structure) {
            Structure structure = (Structure)dataType;
            this.editStructure(service, structure, context);
        } else {
            service.edit(baseDataType);
        }
    }

    private void editStructure(DataTypeManagerService service, Structure structure, DecompilerActionContext context) {
        String fieldName;
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFieldToken && (fieldName = tokenAtCursor.getText()) != null) {
            service.edit((Composite)structure, fieldName);
            return;
        }
        service.edit((DataType)structure);
    }
}

