/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.TLSDirectory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class TLSDataDirectory
extends DataDirectory {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_TLS";
    private TLSDirectory tls;

    TLSDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    public TLSDirectory getTLSDirectory() {
        return this.tls;
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        monitor.setMessage(program.getName() + ": TLS...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        PeUtils.createData(program, addr, this.tls.toDataType(), log);
        AddressSpace space = program.getImageBase().getAddressSpace();
        if (this.tls.getAddressOfCallBacks() != 0L) {
            Pointer pointerDataType = PointerDataType.dataType.clone((DataTypeManager)program.getDataTypeManager());
            try {
                for (int i = 0; i < 20; ++i) {
                    Address nextCallbackPtrAddr = space.getAddress(this.tls.getAddressOfCallBacks() + (long)(i * pointerDataType.getLength()));
                    Address nextCallbackAddr = PointerDataType.getAddressValue((MemBuffer)new DumbMemBufferImpl(program.getMemory(), nextCallbackPtrAddr), (int)pointerDataType.getLength(), (AddressSpace)space);
                    if (nextCallbackAddr != null && nextCallbackAddr.getOffset() != 0L) {
                        PeUtils.createData(program, nextCallbackPtrAddr, (DataType)pointerDataType, log);
                        program.getSymbolTable().createLabel(nextCallbackAddr, "tls_callback_" + i, SourceType.IMPORTED);
                        program.getSymbolTable().addExternalEntryPoint(nextCallbackAddr);
                        continue;
                    }
                    break;
                }
            }
            catch (InvalidInputException e) {
                log.appendMsg("TLS", "Failed to markup TLS callback functions: " + e.getMessage());
            }
        }
        if (this.tls.getAddressOfIndex() != 0L) {
            try {
                Address indexPtrAddr = space.getAddress(this.tls.getAddressOfIndex());
                program.getSymbolTable().createLabel(indexPtrAddr, "_tls_index", SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                log.appendMsg("TLS", "Failed to markup TLS index: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        this.tls = new TLSDirectory(this.reader, ptr, this.ntHeader.getOptionalHeader().is64bit());
        return true;
    }
}

