/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.lang.ref.WeakReference;

public abstract class AbstractLocationPluginEvent
extends PluginEvent {
    private final ProgramLocation location;
    private final WeakReference<Program> programRef;

    protected AbstractLocationPluginEvent(String sourceName, String eventName, ProgramLocation location, Program program) {
        super(sourceName, eventName);
        if (location == null) {
            NullPointerException exc = new NullPointerException("Null ProgramLocation passed to create a Plugin event");
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Null LocationEvent being created.  Trace and remove this problem", (Throwable)exc);
        }
        this.location = location;
        this.programRef = new WeakReference<Program>(program);
    }

    public ProgramLocation getLocation() {
        return this.location;
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    protected String getDetails() {
        if (this.location != null) {
            return this.location.getClass().getName() + " addr==> " + String.valueOf(this.location.getAddress()) + "\n";
        }
        return super.getDetails();
    }
}

