/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BranchOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitCBranchOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.program.model.address.Address;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class CBranchOpGen
extends Enum<CBranchOpGen>
implements OpGen<JitCBranchOp> {
    public static final /* enum */ CBranchOpGen GEN = new CBranchOpGen();
    private static final /* synthetic */ CBranchOpGen[] $VALUES;

    public static CBranchOpGen[] values() {
        return (CBranchOpGen[])$VALUES.clone();
    }

    public static CBranchOpGen valueOf(String name) {
        return Enum.valueOf(CBranchOpGen.class, name);
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitCBranchOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitPassage.RBranch rBranch;
        if (op.op() instanceof JitPassage.ExitPcodeOp && (rBranch = op.branch()) instanceof JitPassage.RExtBranch) {
            JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch;
            assert (eb.reach() == JitPassage.Reachability.MAYBE_CTXMOD);
            Label fall = new Label();
            JitAllocationModel.RunFixedLocal.CTXMOD.generateLoadCode(rv);
            rv.visitJumpInsn(153, fall);
            BranchOpGen.generateExitCode(gen, eb.to().address, block, rv);
            rv.visitLabel(fall);
            return;
        }
        JitType cType = gen.generateValReadCode(op.cond(), op.condType());
        TypeConversions.generateIntToBool(cType, rv);
        JitPassage.RBranch rBranch2 = op.branch();
        Objects.requireNonNull(rBranch2);
        rBranch = rBranch2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.RIntBranch.class, JitPassage.RExtBranch.class}, (Object)rBranch, n)) {
            case 0: {
                JitPassage.RIntBranch ib = (JitPassage.RIntBranch)rBranch;
                IntCBranchGen.C_INT.generateCode(gen, op, ib, block, rv);
                break;
            }
            case 1: {
                JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch;
                ExtCBranchGen.C_EXT.generateCode(gen, op, eb, block, rv);
                break;
            }
            default: {
                throw new AssertionError((Object)"Branch type confusion");
            }
        }
    }

    private static /* synthetic */ CBranchOpGen[] $values() {
        return new CBranchOpGen[]{GEN};
    }

    static {
        $VALUES = CBranchOpGen.$values();
    }

    static class IntCBranchGen
    extends BranchOpGen.IntBranchGen {
        static final IntCBranchGen C_INT = new IntCBranchGen();

        IntCBranchGen() {
        }

        @Override
        void generateCodeWithoutCtxmod(JitCodeGenerator gen, JitOp op, JitPassage.RIntBranch branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            JitControlFlowModel.JitBlock target = block.getTargetBlock(branch);
            Label label = gen.labelForBlock(target);
            VarGen.BlockTransition transition = VarGen.computeBlockTransition(gen, block, target);
            if (transition.needed()) {
                Label fall = new Label();
                rv.visitJumpInsn(153, fall);
                transition.generate(rv);
                rv.visitJumpInsn(167, label);
                rv.visitLabel(fall);
            } else {
                rv.visitJumpInsn(154, label);
            }
        }

        @Override
        void generateCodeWithCtxmod(JitCodeGenerator gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            Label fall = new Label();
            rv.visitJumpInsn(153, fall);
            super.generateCodeWithCtxmod(gen, op, exit, block, rv);
            rv.visitLabel(fall);
        }
    }

    static class ExtCBranchGen
    extends BranchOpGen.ExtBranchGen {
        static final ExtCBranchGen C_EXT = new ExtCBranchGen();

        ExtCBranchGen() {
        }

        @Override
        void generateCodeWithoutCtxmod(JitCodeGenerator gen, JitOp op, JitPassage.RExtBranch branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            Label fall = new Label();
            rv.visitJumpInsn(153, fall);
            super.generateCodeWithoutCtxmod(gen, op, branch, block, rv);
            rv.visitLabel(fall);
        }

        @Override
        void generateCodeWithCtxmod(JitCodeGenerator gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            Label fall = new Label();
            rv.visitJumpInsn(153, fall);
            super.generateCodeWithCtxmod(gen, op, exit, block, rv);
            rv.visitLabel(fall);
        }
    }
}

