/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yacron4j;

import io.nettyx.util.HashedWheelTimer;
import io.nettyx.util.Timeout;
import io.nettyx.util.Timer;
import io.nettyx.util.internal.logging.InternalLogger;
import java.text.ParseException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.quartzx.CronExpression;
import org.rzo.yacron4j.CronTaskImpl;
import org.rzo.yacron4j.DSTCronExpression;
import org.rzo.yacron4j.SchedulerOptions;
import org.rzo.yacron4j.TaskOptions;

public class Scheduler {
    private final Timer _timer;
    private final SchedulerOptions _options;
    private final InternalLogger _logger;
    static AtomicLong ID_COUNTER = new AtomicLong();
    private final boolean _debug;

    public Scheduler() {
        this(new SchedulerOptions());
    }

    public Scheduler(SchedulerOptions options) {
        this._options = (SchedulerOptions)options.clone();
        options.setDebug(true);
        this._logger = this._options.getLogger();
        this._debug = this._options.isDebug();
        ExecutorService executor = options.getMaxThreads() != Integer.MAX_VALUE ? new ThreadPoolExecutor(options.getMaxThreads(), options.getMaxThreads(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(options.getMaxQueueSize()), options.getThreadFactory()) : (options.getMaxQueueSize() == Integer.MAX_VALUE ? Executors.newCachedThreadPool(options.getThreadFactory()) : new ThreadPoolExecutor(options.getMaxQueueSize(), options.getMaxThreads(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(options.getMaxQueueSize()), options.getThreadFactory()));
        this._timer = new HashedWheelTimer(options.getThreadFactory(), options.getTickDuration(), TimeUnit.MILLISECONDS, options.getTicksPerWheel(), executor);
        ((HashedWheelTimer)this._timer).start();
    }

    public synchronized ScheduledFuture schedule(Runnable task, String cronExpression, TaskOptions options) throws ParseException {
        return this.schedule("noname", task, cronExpression, options);
    }

    public synchronized ScheduledFuture schedule(Callable task, String cronExpression, TaskOptions options) throws ParseException {
        return this.schedule("noname", task, cronExpression, options);
    }

    public synchronized ScheduledFuture schedule(Runnable task, String cronExpression) throws ParseException {
        return this.schedule("noname", task, cronExpression, new TaskOptions());
    }

    public synchronized ScheduledFuture schedule(Callable task, String cronExpression) throws ParseException {
        return this.schedule("noname", task, cronExpression, new TaskOptions());
    }

    public synchronized ScheduledFuture schedule(String id, Runnable task, String cronExpression) throws ParseException {
        return this.schedule(id, task, cronExpression, new TaskOptions());
    }

    public synchronized ScheduledFuture schedule(String id, Callable task, String cronExpression) throws ParseException {
        return this.schedule(id, task, cronExpression, new TaskOptions());
    }

    public synchronized ScheduledFuture schedule(String id, Runnable task, String cronExpression, TaskOptions options) throws ParseException {
        if (!this._timer.isStarted()) {
            throw new IllegalStateException("Cannot schedule after shutdown");
        }
        if (task == null) {
            throw new RuntimeException("Cannot schedule null task");
        }
        TaskOptions clonedOptions = (TaskOptions)options.clone();
        CronExpression exp = options.isDstConflictIgnore() ? new CronExpression(cronExpression) : new DSTCronExpression(cronExpression, clonedOptions);
        exp.setTimeZone(options.getTimeZone());
        String uniqueId = id;
        if (id.equals("noname")) {
            uniqueId = String.valueOf(uniqueId) + "-" + ID_COUNTER.incrementAndGet();
        }
        CronTaskImpl result = new CronTaskImpl(uniqueId, this._timer, exp, task, clonedOptions, this._options.getPersistManager());
        if (this._debug) {
            this._logger.info(String.valueOf(uniqueId) + ": scheduling " + cronExpression);
        }
        result.start();
        return result;
    }

    public synchronized ScheduledFuture schedule(String id, Callable task, String cronExpression, TaskOptions options) throws ParseException {
        if (!this._timer.isStarted()) {
            throw new IllegalStateException("Cannot schedule null task");
        }
        if (task == null) {
            throw new RuntimeException("task cannot be null");
        }
        TaskOptions clonedOptions = (TaskOptions)options.clone();
        CronExpression exp = options.isDstConflictIgnore() ? new CronExpression(cronExpression) : new DSTCronExpression(cronExpression, clonedOptions);
        exp.setTimeZone(options.getTimeZone());
        String uniqueId = String.valueOf(id) + "-" + ID_COUNTER.incrementAndGet();
        CronTaskImpl result = new CronTaskImpl(uniqueId, this._timer, exp, task, clonedOptions, this._options.getPersistManager());
        if (this._debug) {
            this._logger.info(String.valueOf(uniqueId) + ": scheduling " + cronExpression);
        }
        result.start();
        return result;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public synchronized void shutdown(boolean mayInterruptIfRunning) {
        Set<Timeout> timeouts = this._timer.stop();
        if (this._debug) {
            this._logger.info("shutdown cron scheduler: canceling " + timeouts.size() + " tasks");
        }
        for (Timeout timeout : timeouts) {
            timeout.cancel();
        }
        this._timer.shutdown(mayInterruptIfRunning);
    }
}

