/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.module.ProgramTreeDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class ProgramTreeDBAdapterV0
extends ProgramTreeDBAdapter {
    static final int V0_VERSION = 0;
    static final int V0_TREE_NAME_COL = 0;
    static final int V0_MODIFICATION_NUM_COL = 1;
    static final Schema V0_PROGRAM_TREE_SCHEMA = new Schema(0, "Key", new Field[]{StringField.INSTANCE, LongField.INSTANCE}, new String[]{"Name", "Modification Number"});
    private Table programTreeTable;

    public ProgramTreeDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.programTreeTable = handle.createTable("Trees", V0_PROGRAM_TREE_SCHEMA, new int[]{0});
        } else {
            this.programTreeTable = handle.getTable("Trees");
            if (this.programTreeTable == null) {
                throw new VersionException("Missing Table: Trees");
            }
            int version = this.programTreeTable.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    DBRecord createRecord(String name) throws IOException {
        DBRecord record = V0_PROGRAM_TREE_SCHEMA.createRecord(this.programTreeTable.getKey());
        record.setString(0, name);
        record.setLongValue(1, 0L);
        this.programTreeTable.putRecord(record);
        return record;
    }

    @Override
    boolean deleteRecord(long treeID) throws IOException {
        return this.programTreeTable.deleteRecord(treeID);
    }

    @Override
    DBRecord getRecord(long treeID) throws IOException {
        return this.programTreeTable.getRecord(treeID);
    }

    @Override
    DBRecord getRecord(String name) throws IOException {
        Field[] keys = this.programTreeTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " trees named " + name);
        }
        return this.programTreeTable.getRecord(keys[0]);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.programTreeTable.iterator();
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.programTreeTable.putRecord(record);
    }
}

