/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseNumericToken;
import ghidra.program.model.address.AddressSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class AssemblyNumericTerminal
extends AssemblyTerminal {
    public static final String PREFIX_HEX = "0x";
    public static final String PREFIX_OCT = "0";
    protected static final Collection<String> SUGGESTIONS = List.of("0", "1", "0x0", "+0x0", "-0x0", "01");
    protected static final int MAX_LABEL_SUGGESTIONS = 10;
    protected final int bitsize;
    protected final AddressSpace space;

    public AssemblyNumericTerminal(String name, int bitsize, AddressSpace space) {
        super(name);
        this.bitsize = bitsize;
        this.space = space;
    }

    @Override
    public String toString() {
        if (this.bitsize == 0) {
            return "[num:" + this.name + "]";
        }
        return "[num" + this.bitsize + ":" + this.name + "]";
    }

    public AssemblyParseNumericToken match(String buffer) {
        Collection<AssemblyParseNumericToken> col = this.match(buffer, 0, null, AssemblyNumericSymbols.EMPTY);
        if (col.isEmpty()) {
            return null;
        }
        if (col.size() == 1) {
            return col.iterator().next();
        }
        throw new AssertionError((Object)("Multiple results for a numeric terminal?: " + String.valueOf(col)));
    }

    public Collection<AssemblyParseNumericToken> match(String buffer, int pos, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
        if (pos >= buffer.length()) {
            return Collections.emptySet();
        }
        if (buffer.charAt(pos) == '+') {
            return this.matchLiteral(pos + 1, buffer, pos, false, grammar);
        }
        if (buffer.charAt(pos) == '-') {
            return this.matchLiteral(pos + 1, buffer, pos, true, grammar);
        }
        return this.match(pos, buffer, grammar, symbols);
    }

    protected Collection<AssemblyParseNumericToken> match(int s, String buffer, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
        char c;
        int b;
        if (s >= buffer.length()) {
            return Collections.emptySet();
        }
        if (Character.isDigit(buffer.charAt(s))) {
            return this.matchLiteral(s, buffer, s, false, grammar);
        }
        for (b = s; b < buffer.length() && Character.isJavaIdentifierPart(c = buffer.charAt(b)); ++b) {
        }
        String lab = buffer.substring(s, b);
        return symbols.choose(lab, this.space).stream().map(val -> new AssemblyParseNumericToken(grammar, this, lab, (long)val)).collect(Collectors.toList());
    }

    protected Collection<AssemblyParseNumericToken> matchLiteral(int s, String buffer, int pos, boolean neg, AssemblyGrammar grammar) {
        if (buffer.regionMatches(s, PREFIX_HEX, 0, PREFIX_HEX.length())) {
            return this.matchHex(s + PREFIX_HEX.length(), buffer, pos, neg, grammar);
        }
        if (buffer.regionMatches(s, PREFIX_OCT, 0, PREFIX_OCT.length())) {
            return this.matchOct(s + PREFIX_OCT.length(), buffer, pos, neg, grammar);
        }
        return this.matchDec(s, buffer, pos, neg, grammar);
    }

    protected Collection<AssemblyParseNumericToken> makeToken(String str, String num, int radix, boolean neg, AssemblyGrammar grammar) {
        if (num.length() == 0) {
            return Collections.emptySet();
        }
        try {
            long val = Long.parseUnsignedLong(num, radix);
            if (neg) {
                val = -val;
            }
            if (this.bitsize != 0 && this.bitsize != 64) {
                if (val < -1L << this.bitsize - 1) {
                    return Collections.emptySet();
                }
                if (val >= 1L << this.bitsize) {
                    return Collections.emptySet();
                }
            }
            return Collections.singleton(new AssemblyParseNumericToken(grammar, this, str, val));
        }
        catch (NumberFormatException e) {
            return Collections.emptySet();
        }
    }

    protected Collection<AssemblyParseNumericToken> matchHex(int s, String buffer, int pos, boolean neg, AssemblyGrammar grammar) {
        char c;
        int b;
        for (b = s; b < buffer.length() && ('0' <= (c = buffer.charAt(b)) && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f'); ++b) {
        }
        return this.makeToken(buffer.substring(pos, b), buffer.substring(s, b), 16, neg, grammar);
    }

    protected Collection<AssemblyParseNumericToken> matchDec(int s, String buffer, int pos, boolean neg, AssemblyGrammar grammar) {
        char c;
        int b;
        for (b = s; b < buffer.length() && '0' <= (c = buffer.charAt(b)) && c <= '9'; ++b) {
        }
        return this.makeToken(buffer.substring(pos, b), buffer.substring(s, b), 10, neg, grammar);
    }

    protected Collection<AssemblyParseNumericToken> matchOct(int s, String buffer, int pos, boolean neg, AssemblyGrammar grammar) {
        char c;
        int b;
        for (b = s; b < buffer.length() && '0' <= (c = buffer.charAt(b)) && c <= '7'; ++b) {
        }
        if (b == s) {
            return this.makeToken(buffer.substring(pos, b), PREFIX_OCT, 8, neg, grammar);
        }
        return this.makeToken(buffer.substring(pos, b), buffer.substring(s, b), 8, neg, grammar);
    }

    @Override
    public Collection<String> getSuggestions(String got, AssemblyNumericSymbols symbols) {
        TreeSet<String> s = new TreeSet<String>(SUGGESTIONS);
        s.addAll(symbols.getSuggestions(got, this.space, 10));
        return s;
    }

    public int getBitSize() {
        return this.bitsize;
    }

    public AddressSpace getSpace() {
        return this.space;
    }
}

