/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TrampolineMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DisassembleableAddressSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class TrampolineSymbolApplier
extends MsSymbolApplier
implements DirectSymbolApplier,
DisassembleableAddressSymbolApplier {
    private TrampolineMsSymbol symbol;

    public TrampolineSymbolApplier(DefaultPdbApplicator applicator, TrampolineMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        Address targetAddress = this.applicator.getAddress(this.symbol.getSegmentTarget(), this.symbol.getOffsetTarget());
        Address address = this.applicator.getAddress(this.symbol);
        Function target = null;
        Function thunk = null;
        if (!this.applicator.isInvalidAddress(targetAddress, "thunk target")) {
            target = this.applicator.getExistingOrCreateOneByteFunction(targetAddress);
        }
        if (!this.applicator.isInvalidAddress(address, "thunk symbol")) {
            thunk = this.applicator.getExistingOrCreateOneByteFunction(address);
        }
        if (target != null && thunk != null) {
            thunk.setThunkedFunction(target);
        }
    }

    @Override
    public Address getAddressForDisassembly() {
        return this.applicator.getAddress(this.symbol);
    }

    private TrampolineMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof TrampolineMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        TrampolineMsSymbol trampolineSymbol = (TrampolineMsSymbol)abstractSymbol;
        return trampolineSymbol;
    }
}

