/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.ipc;

import ghidra.app.plugin.core.go.exception.UnableToGetLockException;
import ghidra.app.plugin.core.go.ipc.GhidraGoIPC;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class GhidraGoListener
extends GhidraGoIPC
implements Runnable {
    public static int WAIT_FOR_ACTIVE_PROJECT_TIMEOUT_S = 30;
    private Thread t;
    private Consumer<URL> onNewUrl;

    public GhidraGoListener(Consumer<URL> onNewUrl) throws IOException {
        this.onNewUrl = onNewUrl;
        this.t = new Thread((Runnable)this, "GhidraGo Handler");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            GhidraGoListener.doLockedAction(this.listenerLockPath, true, () -> {
                try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                    this.urlFilesPath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
                    Msg.info((Object)this, (Object)"Listening for GhidraGo Requests.");
                    GhidraGoListener.doLockedAction(this.listenerReadyLockPath, true, () -> {
                        try {
                            WatchKey key;
                            while ((key = watchService.take()) != null) {
                                for (WatchEvent<?> event : key.pollEvents()) {
                                    if (event.context() == null) continue;
                                    Msg.trace((Object)this, (Object)(String.valueOf(event.context()) + " is a new file!"));
                                    Path urlFilePath = this.urlFilesPath.resolve(event.context().toString());
                                    URL url = this.getGhidraURL(urlFilePath);
                                    urlFilePath.toFile().delete();
                                    if (url == null) continue;
                                    this.onNewUrl.accept(url);
                                }
                                key.reset();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return true;
                    });
                }
                catch (InterruptedIOException | FileLockInterruptionException e) {
                    Boolean bl = false;
                    return bl;
                }
                catch (UnableToGetLockException | IOException e) {
                    Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Unable to Watch for New GhidraURL's", (Object)e));
                    Boolean bl = false;
                    return bl;
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                }
                finally {
                    Msg.info((Object)this, (Object)"No longer listening for GhidraGo Requests.");
                }
                return true;
            });
        }
        catch (UnableToGetLockException | OverlappingFileLockException e) {
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Unable to Watch for New GhidraURL's", (Object)e));
        }
    }

    private URL toURL(String ghidraGoArgument) throws IllegalArgumentException {
        try {
            if (((String)ghidraGoArgument).startsWith("ghidra:?")) {
                Object projectFilePath = ((String)ghidraGoArgument).substring(((String)ghidraGoArgument).indexOf("?") + 1);
                if (!((String)projectFilePath).startsWith("/")) {
                    projectFilePath = "/" + (String)projectFilePath;
                }
                return GhidraURL.makeURL((ProjectLocator)AppInfo.getActiveProject().getProjectLocator(), (String)projectFilePath, null);
            }
            return GhidraURL.toURL((String)ghidraGoArgument);
        }
        catch (IllegalArgumentException e) {
            if (((String)ghidraGoArgument).startsWith("ghidra://") || AppInfo.getActiveProject() == null) {
                throw e;
            }
            if (!((String)ghidraGoArgument).startsWith("/")) {
                ghidraGoArgument = "/" + (String)ghidraGoArgument;
            }
            return GhidraURL.makeURL((ProjectLocator)AppInfo.getActiveProject().getProjectLocator(), (String)ghidraGoArgument, null);
        }
    }

    private URL getGhidraURL(Path urlFilePath) {
        try {
            String urlContents = new String(Files.readAllBytes(urlFilePath));
            if (StringUtils.isEmpty((CharSequence)urlContents)) {
                Swing.runNow(() -> Msg.showError(GhidraGoIPC.class, null, (String)"GhidraGo Empty GhidraURL Read", (Object)"The GhidraURL read from url file was null or empty. This should not happen, ensure ghidraGo is being used properly."));
                return null;
            }
            return this.toURL(urlContents);
        }
        catch (IOException e) {
            Swing.runNow(() -> Msg.showError(GhidraGoIPC.class, null, (String)"GhidraGo Error", (Object)("Failed to read the url from " + String.valueOf(urlFilePath)), (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            Swing.runNow(() -> Msg.showError(GhidraGoIPC.class, null, (String)"GhidraGo Illegal Argument Given", (Object)e));
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.t != null) {
            this.t.interrupt();
        }
    }
}

