/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import generic.test.AbstractGenericTest;
import ghidra.base.project.GhidraProject;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utilities.util.FileUtilities;

public class XmlTestHelper {
    private GhidraProject gp;
    private boolean disposeProject;
    private File tempDir;
    private List<String> xmlList = new ArrayList<String>();

    public XmlTestHelper(String tmpDirPath, GhidraProject gp) throws Exception {
        this.createTempDir(tmpDirPath);
        this.gp = gp;
        this.disposeProject = false;
    }

    public XmlTestHelper(String tmpDirPath) throws Exception {
        this.createTempDir(tmpDirPath);
        this.gp = GhidraProject.createProject(this.tempDir.getAbsolutePath(), "xmlTempProj", true);
        this.disposeProject = true;
    }

    private void createTempDir(String tmpDirPath) {
        this.tempDir = new File(tmpDirPath, "xmlHelper");
        if (this.tempDir.exists()) {
            FileUtilities.deleteDir((File)this.tempDir);
        }
        this.tempDir.mkdirs();
    }

    public void dispose() {
        if (this.disposeProject) {
            this.gp.close();
        }
    }

    public void add(String xml) {
        this.xmlList.add(xml);
    }

    public void loadXmlResource(Package pkg, String name) throws IOException {
        String pkgName = pkg.getName();
        pkgName = pkgName.replace('.', '/');
        String resourceName = "/" + pkgName + "/" + name;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is == null) {
            throw new IOException("Could not find resource: " + resourceName);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            this.xmlList.add(line);
        }
        br.close();
    }

    public File getTempFile(String name) {
        return new File(this.tempDir, name);
    }

    public GhidraProject getProject() {
        return this.gp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareXml(File file) throws Exception {
        Msg.debug((Object)this, (Object)("reading test file from: " + String.valueOf(file)));
        Iterator<String> it = this.xmlList.iterator();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            int linenum = 0;
            while ((line = reader.readLine()) != null && it.hasNext()) {
                ++linenum;
                String compareLine = it.next();
                if (!compareLine.equals(line)) {
                    System.out.println("XML not Equal (line:" + linenum + ")");
                    System.out.println("   " + compareLine);
                    System.out.println("   " + line);
                }
                Assert.assertEquals((String)("Line " + linenum + " not equal: "), (Object)compareLine, (Object)line);
            }
            if (line != null) {
                Assert.fail((String)("XML File contains unexpected line: " + line));
            }
        }
        if (it.hasNext()) {
            Assert.fail((String)("XML contains unexpected line: " + it.next()));
        }
    }

    public boolean containsXml(String line) {
        boolean contains = this.xmlList.contains(line);
        return contains;
    }

    public void printExpectedLines() {
        Msg.debug((Object)this, (Object)"XML Lines: ");
        for (String line : this.xmlList) {
            Msg.debug((Object)this, (Object)line);
        }
    }

    public XmlPullParser getXmlParser(String name) throws IOException, SAXException {
        File file = new File(this.tempDir, name);
        file.deleteOnExit();
        FileWriter writer = new FileWriter(file);
        for (String xml : this.xmlList) {
            writer.write(xml);
            writer.write(10);
        }
        writer.close();
        XmlPullParser parser = XmlPullParserFactory.create((File)file, null, (boolean)false);
        return parser;
    }

    public void clearXml() {
        this.xmlList.clear();
    }

    public Program loadResourceProgram(String programName) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException {
        File file = AbstractGenericTest.getTestDataFile((String)programName);
        if (!file.exists()) {
            throw new FileNotFoundException("Can not find test program: " + programName);
        }
        return this.getProject().importProgramFast(file);
    }

    public static void assertXMLFilesEquals(File expectedXMLFile, File testXMLFile) throws SAXException, IOException {
        XmlPullParser expectedXMLParser = XmlPullParserFactory.create((File)expectedXMLFile, null, (boolean)false);
        XmlPullParser testXMLParser = XmlPullParserFactory.create((File)testXMLFile, null, (boolean)false);
        XmlTestHelper.assertXMLFilesEquals(expectedXMLParser, testXMLParser);
    }

    public static void assertXMLFilesEquals(XmlPullParser expectedXMLParser, XmlPullParser testXMLParser) {
        ArrayDeque<String> currentPath = new ArrayDeque<String>();
        while (expectedXMLParser.peek() != null && testXMLParser.peek() != null) {
            String testContent;
            XmlElement expectedElement = expectedXMLParser.next();
            XmlElement testElement = testXMLParser.next();
            if (expectedElement.isStart()) {
                currentPath.addLast(expectedElement.getName());
            }
            if (expectedElement.isStart() != testElement.isStart() || expectedElement.isEnd() != testElement.isEnd()) {
                XmlTestHelper.failWithInfo("Element start/stop type does not match", expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
            }
            if (!expectedElement.getName().equals(testElement.getName())) {
                XmlTestHelper.failWithInfo("Element names do not match", expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
            }
            if (expectedElement.isStart()) {
                Map testAttrs = testElement.getAttributes();
                for (Map.Entry expectedAttr : expectedElement.getAttributes().entrySet()) {
                    if (!testAttrs.containsKey(expectedAttr.getKey())) {
                        XmlTestHelper.failWithInfo("Attribute " + (String)expectedAttr.getKey() + " missing", expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
                    }
                    String testAttrVal = (String)testAttrs.get(expectedAttr.getKey());
                    if (!((String)expectedAttr.getValue()).equals(testAttrVal)) {
                        XmlTestHelper.failWithInfo("Attribute " + (String)expectedAttr.getKey() + " values do not match", expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
                    }
                    testAttrs.remove(expectedAttr.getKey());
                }
                if (!testAttrs.isEmpty()) {
                    XmlTestHelper.failWithInfo("Unexpected attributes found: " + testAttrs.keySet().toString(), expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
                }
            }
            if (!expectedElement.isEnd()) continue;
            String expectedContent = expectedElement.getText().trim();
            if (!expectedContent.equals(testContent = testElement.getText().trim())) {
                XmlTestHelper.failWithInfo("Text content does not match: /" + expectedContent + "/ vs /" + testContent + "/", expectedXMLParser, testXMLParser, expectedElement, testElement, currentPath);
            }
            currentPath.removeLast();
        }
    }

    static String join(Collection<String> coll, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String s : coll) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static void failWithInfo(String msg, XmlPullParser parser1, XmlPullParser parser2, XmlElement element1, XmlElement element2, Collection<String> currentPath) {
        Assert.fail((String)("XML compare FAILED between\n" + parser1.getName() + ":" + parser1.getLineNumber() + " and " + parser2.getName() + ":" + parser2.getLineNumber() + "\n at path " + XmlTestHelper.join(currentPath, "/") + ":\n" + msg + "\nElement 1: " + element1.toString() + "\nElement 2: " + element2.toString()));
    }

    class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler(XmlTestHelper this$0) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }
}

