/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.RelocByIndexGroup;
import ghidra.app.util.bin.format.pef.RelocBySectDWithSkip;
import ghidra.app.util.bin.format.pef.RelocIncrPosition;
import ghidra.app.util.bin.format.pef.RelocLgByImport;
import ghidra.app.util.bin.format.pef.RelocLgRepeat;
import ghidra.app.util.bin.format.pef.RelocLgSetOrBySection;
import ghidra.app.util.bin.format.pef.RelocSetPosition;
import ghidra.app.util.bin.format.pef.RelocSmRepeat;
import ghidra.app.util.bin.format.pef.RelocUndefinedOpcode;
import ghidra.app.util.bin.format.pef.RelocValueGroup;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;

public class RelocationFactory {
    private static Class<?>[] relocationClasses = new Class[]{RelocByIndexGroup.class, RelocBySectDWithSkip.class, RelocIncrPosition.class, RelocLgByImport.class, RelocLgRepeat.class, RelocLgSetOrBySection.class, RelocSetPosition.class, RelocSmRepeat.class, RelocUndefinedOpcode.class, RelocValueGroup.class};

    public static Relocation getRelocation(BinaryReader reader) {
        long index = reader.getPointerIndex();
        for (Class<?> relocationClass : relocationClasses) {
            try {
                Constructor<?> constructor = relocationClass.getDeclaredConstructor(BinaryReader.class);
                Relocation relocation = (Relocation)constructor.newInstance(reader);
                if (relocation.isMatch()) {
                    return relocation;
                }
            }
            catch (Exception e) {
                Msg.error(RelocationFactory.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            reader.setPointerIndex(index);
        }
        throw new IllegalStateException();
    }
}

