/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.cmd.label.AddUniqueLabelCmd;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class RelocValueGroup
extends Relocation {
    public static final int kPEFRelocBySectC = 0;
    public static final int kPEFRelocBySectD = 1;
    public static final int kPEFRelocTVector12 = 2;
    public static final int kPEFRelocTVector8 = 3;
    public static final int kPEFRelocVTable8 = 4;
    public static final int kPEFRelocImportRun = 5;
    private int subopcode;
    private int runLength;

    RelocValueGroup(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xE000) >> 13;
        this.subopcode = (value & 0x1E00) >> 9;
        this.runLength = value & 0x1FF;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 2;
    }

    public int getSubopcode() {
        return this.subopcode;
    }

    public int getRunLength() {
        return this.runLength + 1;
    }

    @Override
    public String toString() {
        switch (this.subopcode) {
            case 0: {
                return "RelocBySectC";
            }
            case 1: {
                return "RelocBySectD";
            }
            case 2: {
                return "RelocTVector12";
            }
            case 3: {
                return "RelocTVector8";
            }
            case 4: {
                return "RelocVTable8";
            }
            case 5: {
                return "RelocImportRun";
            }
        }
        return super.toString();
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        List<ImportedSymbol> importedSymbols = header.getLoader().getImportedSymbols();
        switch (this.subopcode) {
            case 0: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionC().getOffset(), log);
                    relocState.incrementRelocationAddress(4);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionD().getOffset(), log);
                    relocState.incrementRelocationAddress(4);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionC().getOffset(), log);
                    relocState.incrementRelocationAddress(4);
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionD().getOffset(), log);
                    relocState.incrementRelocationAddress(4);
                    relocState.incrementRelocationAddress(4);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionC().getOffset(), log);
                    relocState.incrementRelocationAddress(4);
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionD().getOffset(), log);
                    if (importState.getTocAddress() == null) {
                        try {
                            Address relocationAddress = relocState.getRelocationAddress();
                            int tocAddressValue = program.getMemory().getInt(relocationAddress);
                            AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
                            Address tocAddress = space.getAddress((long)tocAddressValue & 0xFFFFFFFFL);
                            importState.setTocAddress(tocAddress);
                        }
                        catch (MemoryAccessException relocationAddress) {
                            // empty catch block
                        }
                    }
                    relocState.incrementRelocationAddress(4);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)relocState.getSectionD().getOffset(), log);
                    relocState.incrementRelocationAddress(8);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.runLength + 1; ++i) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    ImportedLibrary library = header.getLoader().findLibrary(relocState.getImportIndex());
                    ImportedSymbol importedSymbol = importedSymbols.get(relocState.getImportIndex());
                    Namespace namespace = importState.getTVectNamespace();
                    String name = SymbolUtilities.replaceInvalidChars((String)importedSymbol.getName(), (boolean)true);
                    AddUniqueLabelCmd cmd = new AddUniqueLabelCmd(relocState.getRelocationAddress(), name, namespace, SourceType.IMPORTED);
                    if (!cmd.applyTo(program)) {
                        log.appendMsg(cmd.getStatusMsg());
                    }
                    Symbol symbol = importState.getSymbol(name, library);
                    relocState.fixupMemory(relocState.getRelocationAddress(), symbol.getAddress(), log);
                    relocState.incrementRelocationAddress(4);
                    relocState.incrementImportIndex();
                }
                break;
            }
            default: {
                log.appendMsg("Unsupported RelocValueGroup subopcode: " + this.subopcode);
            }
        }
    }
}

