/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class OMFSegMapDesc {
    static final int IMAGE_SIZEOF_OMF_SEG_MAP_DESC = 20;
    private short flags;
    private short ovl;
    private short group;
    private short frame;
    private short iSegName;
    private short iClassName;
    private int offset;
    private int cbSeg;

    OMFSegMapDesc(BinaryReader reader, int ptr) throws IOException {
        this.flags = reader.readShort(ptr);
        this.ovl = reader.readShort(ptr += 2);
        this.group = reader.readShort(ptr += 2);
        this.frame = reader.readShort(ptr += 2);
        this.iSegName = reader.readShort(ptr += 2);
        this.iClassName = reader.readShort(ptr += 2);
        this.offset = reader.readInt(ptr += 2);
        this.cbSeg = reader.readInt(ptr += 4);
        ptr += 4;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getLogicalOverlayNumber() {
        return this.ovl;
    }

    public short getGroupIndex() {
        return this.group;
    }

    public short getLogicalSegmentIndex() {
        return this.frame;
    }

    public short getSegmentName() {
        return this.iSegName;
    }

    public short getClassName() {
        return this.iClassName;
    }

    public int getByteOffset() {
        return this.offset;
    }

    public int getByteCount() {
        return this.cbSeg;
    }
}

