/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Random;
import java.util.concurrent.Executor;
import org.jungrapht.visualization.layout.algorithms.AbstractLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.IterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.AfterRunnable;
import org.jungrapht.visualization.layout.algorithms.util.Threaded;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIterativeLayoutAlgorithm<V>
extends AbstractLayoutAlgorithm<V>
implements IterativeLayoutAlgorithm<V>,
AfterRunnable,
Threaded {
    private static final Logger log = LoggerFactory.getLogger(AbstractIterativeLayoutAlgorithm.class);
    protected LayoutModel<V> layoutModel;
    protected Executor executor;
    protected boolean shouldPreRelax;
    protected int preRelaxDurationMs;
    protected Random random;
    protected Runnable afterRunnable;
    protected boolean threaded;
    protected boolean cancelled;

    protected AbstractIterativeLayoutAlgorithm(Builder builder) {
        super(builder);
        this.executor = builder.executor;
        this.random = builder.random;
        this.shouldPreRelax = builder.shouldPrerelax;
        this.preRelaxDurationMs = builder.preRelaxDurationMs;
        this.afterRunnable = builder.afterRunnable;
        this.threaded = builder.threaded;
    }

    public void setRandomSeed(long randomSeed) {
        this.random = new Random(randomSeed);
    }

    @Override
    public final boolean preRelax() {
        if (!this.shouldPreRelax) {
            return false;
        }
        long timeNow = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeNow < (long)this.preRelaxDurationMs && !this.done()) {
            this.step();
        }
        return true;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        log.debug("visiting " + layoutModel);
        this.layoutModel = layoutModel;
    }

    @Override
    public boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.layoutModel != null) {
            this.layoutModel.stop();
        }
    }

    public static abstract class Builder<V, T extends AbstractIterativeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected Executor executor;
        protected Random random = new Random();
        protected boolean shouldPrerelax = true;
        protected int preRelaxDurationMs = 500;
        protected Runnable afterRunnable = () -> {};
        protected boolean threaded = true;

        public B randomSeed(long randomSeed) {
            this.random = new Random(randomSeed);
            return (B)this.self();
        }

        public B prerelax(boolean shouldPrerelax) {
            this.shouldPrerelax = shouldPrerelax;
            return (B)this.self();
        }

        public B preRelaxDuration(int preRelaxDurationMs) {
            this.preRelaxDurationMs = preRelaxDurationMs;
            return (B)this.self();
        }

        public B executor(Executor executor) {
            this.executor = executor;
            return (B)this.self();
        }

        public B afterRunnable(Runnable afterRunnable) {
            this.afterRunnable = afterRunnable;
            return (B)this.self();
        }

        public B threaded(boolean threaded) {
            this.threaded = threaded;
            return (B)this.self();
        }

        @Override
        protected B self() {
            return (B)this;
        }

        @Override
        public abstract T build();
    }
}

