import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { CommandKind } from '../commands/types.js';
import { KEYBOARD_SHORTCUTS_URL } from '../constants.js';
export const Help = ({ commands }) => (_jsxs(Box, { flexDirection: "column", marginBottom: 1, borderColor: theme.border.default, borderStyle: "round", padding: 1, children: [_jsx(Text, { bold: true, color: theme.text.primary, children: "Basics:" }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Add context" }), ": Use", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: "@" }), ' ', "to specify files for context (e.g.,", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: "@src/myFile.ts" }), ") to target specific files or folders."] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Shell mode" }), ": Execute shell commands via", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: "!" }), ' ', "(e.g.,", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: "!npm run start" }), ") or use natural language (e.g.", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: "start server" }), ")."] }), _jsx(Box, { height: 1 }), _jsx(Text, { bold: true, color: theme.text.primary, children: "Commands:" }), commands
            .filter((command) => command.description && !command.hidden)
            .map((command) => (_jsxs(Box, { flexDirection: "column", children: [_jsxs(Text, { color: theme.text.primary, children: [_jsxs(Text, { bold: true, color: theme.text.accent, children: [' ', "/", command.name] }), command.kind === CommandKind.MCP_PROMPT && (_jsx(Text, { color: theme.text.secondary, children: " [MCP]" })), command.description && ' - ' + command.description] }), command.subCommands &&
                    command.subCommands
                        .filter((subCommand) => !subCommand.hidden)
                        .map((subCommand) => (_jsxs(Text, { color: theme.text.primary, children: [_jsxs(Text, { bold: true, color: theme.text.accent, children: ['   ', subCommand.name] }), subCommand.description && ' - ' + subCommand.description] }, subCommand.name)))] }, command.name))), _jsxs(Text, { color: theme.text.primary, children: [_jsxs(Text, { bold: true, color: theme.text.accent, children: [' ', "!", ' '] }), "- shell command"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { color: theme.text.secondary, children: "[MCP]" }), " - Model Context Protocol command (from external servers)"] }), _jsx(Box, { height: 1 }), _jsx(Text, { bold: true, color: theme.text.primary, children: "Keyboard Shortcuts:" }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Alt+Left/Right" }), ' ', "- Jump through words in the input"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Ctrl+C" }), ' ', "- Quit application"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: process.platform === 'win32' ? 'Ctrl+Enter' : 'Ctrl+J' }), ' ', process.platform === 'linux'
                    ? '- New line (Alt+Enter works for certain linux distros)'
                    : '- New line'] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Ctrl+L" }), ' ', "- Clear the screen"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Ctrl+S" }), ' ', "- Enter selection mode to copy text"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Ctrl+X" }), ' ', "- Open input in external editor"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Ctrl+Y" }), ' ', "- Toggle YOLO mode"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Enter" }), ' ', "- Send message"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Esc" }), ' ', "- Cancel operation / Clear input (double press)"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Page Up/Down" }), ' ', "- Scroll page up/down"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Shift+Tab" }), ' ', "- Toggle auto-accepting edits"] }), _jsxs(Text, { color: theme.text.primary, children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "Up/Down" }), ' ', "- Cycle through your prompt history"] }), _jsx(Box, { height: 1 }), _jsxs(Text, { color: theme.text.primary, children: ["For a full list of shortcuts, see", ' ', _jsx(Text, { bold: true, color: theme.text.accent, children: KEYBOARD_SHORTCUTS_URL })] })] }));
//# sourceMappingURL=Help.js.map