import { OAuthClientInformationFull } from '../../shared/auth.js';
/**
 * Stores information about registered OAuth clients for this server.
 */
export interface OAuthRegisteredClientsStore {
    /**
     * Returns information about a registered client, based on its ID.
     */
    getClient(clientId: string): OAuthClientInformationFull | undefined | Promise<OAuthClientInformationFull | undefined>;
    /**
     * Registers a new client with the server. The client ID and secret will be automatically generated by the library. A modified version of the client information can be returned to reflect specific values enforced by the server.
     *
     * NOTE: Implementations should NOT delete expired client secrets in-place. Auth middleware provided by this library will automatically check the `client_secret_expires_at` field and reject requests with expired secrets. Any custom logic for authenticating clients should check the `client_secret_expires_at` field as well.
     *
     * If unimplemented, dynamic client registration is unsupported.
     */
    registerClient?(client: Omit<OAuthClientInformationFull, 'client_id' | 'client_id_issued_at'>): OAuthClientInformationFull | Promise<OAuthClientInformationFull>;
}
//# sourceMappingURL=clients.d.ts.map