//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file medical/dna/wvalue/src/EventAction.cc
/// \brief Implementation of the EventAction class
//
// $Id: EventAction.cc 78723 2014-01-20 10:32:17Z gcosmo $
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#include "EventAction.hh"

#include "Run.hh"
#include "HistoManager.hh"

#include "G4RunManager.hh"
#include "G4SystemOfUnits.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

EventAction::EventAction()
:G4UserEventAction()
{ }

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

EventAction::~EventAction()
{ }

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void EventAction::BeginOfEventAction(const G4Event*)
{    
 //energy deposited per event
 fTotalEdep = 0.;   

 //nb of inelastic events per event
 fNbInelastic = 0.;   
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void EventAction::EndOfEventAction(const G4Event*)
{
  //plot nb of inelastic interactions per event
  //
  if (fNbInelastic > 0.) {

    Run* run
    = static_cast<Run*>(G4RunManager::GetRunManager()->GetNonConstCurrentRun());
    
    run->AddInelastic(fNbInelastic);
    
    //G4cout << "*** Nb of cumulated inelastic interactions = " << run->GetInelastic() << G4endl;
    
    G4AnalysisManager* analysisManager = G4AnalysisManager::Instance();    
    analysisManager->FillH1(1,fNbInelastic);
  }  

  //plot energy deposited per event
  //
  if (fTotalEdep > 0.) {
    
    Run* run
    = static_cast<Run*>(G4RunManager::GetRunManager()->GetNonConstCurrentRun());
    
    run->AddEdep(fTotalEdep);
    
    //G4cout << "*** Edep cumulated (eV) = " << run->GetEdep()/eV << G4endl;
    //G4cout << "*** Edep (eV) = " << fTotalEdep/eV << G4endl;
    
    G4AnalysisManager* analysisManager = G4AnalysisManager::Instance();    
    analysisManager->FillH1(2,fTotalEdep);
  }  

}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
