//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: GammaKnifeActionInitialization.cc 68058 2013-03-13 14:47:43Z gcosmo $
//
/// \file GammaKnifeActionInitialization.cc
/// \brief Implementation of the GammaKnifeActionInitialization class

#include "GammaKnifeActionInitialization.hh"
#include "GammaKnifePrimaryGeneratorAction.hh"
#include "GammaKnifeRunAction.hh"
#include "G4GeneralParticleSource.hh"
#include "G4ParticleTable.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

GammaKnifeActionInitialization::GammaKnifeActionInitialization()
 : G4VUserActionInitialization()
{
  //Defatults are set once by master
    masterGPS = new G4GeneralParticleSource();
    G4ParticleTable* particleTable = G4ParticleTable::GetParticleTable();
    G4ParticleDefinition* particle = particleTable->FindParticle("gamma");
    masterGPS->SetParticleDefinition(particle);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

GammaKnifeActionInitialization::~GammaKnifeActionInitialization()
{
  delete masterGPS;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void GammaKnifeActionInitialization::BuildForMaster() const
{
  SetUserAction(new GammaKnifeRunAction(true));
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void GammaKnifeActionInitialization::Build() const
{
  SetUserAction(new GammaKnifePrimaryGeneratorAction);
  SetUserAction(new GammaKnifeRunAction(false));

}  

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
