/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2016 Philippe Proulx <pproulx@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * The following C code was generated by barectf 2.2.1
 * on 2018-08-21T22:52:11.846748.
 *
 * For more details, see <http://barectf.org>.
 */

#include <stdint.h>
#include <string.h>
#include <assert.h>

#include "esmftrc.h"

#define _ALIGN(_at, _align)					\
	do {							\
		(_at) = ((_at) + ((_align) - 1)) & -(_align);	\
	} while (0)

#ifdef __cplusplus
# define TO_VOID_PTR(_value)		static_cast<void *>(_value)
# define FROM_VOID_PTR(_type, _value)	static_cast<_type *>(_value)
#else
# define TO_VOID_PTR(_value)		((void *) (_value))
# define FROM_VOID_PTR(_type, _value)	((_type *) (_value))
#endif

#define _BITS_TO_BYTES(_x)	((_x) >> 3)
#define _BYTES_TO_BITS(_x)	((_x) << 3)

union f2u {
	float f;
	uint32_t u;
};

union d2u {
	double f;
	uint64_t u;
};

uint32_t esmftrc_packet_size(void *ctx)
{
	return FROM_VOID_PTR(struct esmftrc_ctx, ctx)->packet_size;
}

int esmftrc_packet_is_full(void *ctx)
{
	struct esmftrc_ctx *cctx = FROM_VOID_PTR(struct esmftrc_ctx, ctx);

	return cctx->at == cctx->packet_size;
}

int esmftrc_packet_is_empty(void *ctx)
{
	struct esmftrc_ctx *cctx = FROM_VOID_PTR(struct esmftrc_ctx, ctx);

	return cctx->at <= cctx->off_content;
}

uint32_t esmftrc_packet_events_discarded(void *ctx)
{
	return FROM_VOID_PTR(struct esmftrc_ctx, ctx)->events_discarded;
}

uint8_t *esmftrc_packet_buf(void *ctx)
{
	return FROM_VOID_PTR(struct esmftrc_ctx, ctx)->buf;
}

uint32_t esmftrc_packet_buf_size(void *ctx)
{
	struct esmftrc_ctx *cctx = FROM_VOID_PTR(struct esmftrc_ctx, ctx);

	return _BITS_TO_BYTES(cctx->packet_size);
}

void esmftrc_packet_set_buf(void *ctx, uint8_t *buf, uint32_t buf_size)
{
	struct esmftrc_ctx *cctx = FROM_VOID_PTR(struct esmftrc_ctx, ctx);

	cctx->buf = buf;
	cctx->packet_size = _BYTES_TO_BITS(buf_size);
}

int esmftrc_packet_is_open(void *ctx)
{
	return FROM_VOID_PTR(struct esmftrc_ctx, ctx)->packet_is_open;
}

static
void _write_cstring(struct esmftrc_ctx *ctx, const char *src)
{
	uint32_t sz = strlen(src) + 1;

	memcpy(&ctx->buf[_BITS_TO_BYTES(ctx->at)], src, sz);
	ctx->at += _BYTES_TO_BITS(sz);
}

static
int _reserve_event_space(void *vctx, uint32_t ev_size)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);

	/* event _cannot_ fit? */
	if (ev_size > (ctx->packet_size - ctx->off_content)) {
		ctx->events_discarded++;

		return 0;
	}

	/* packet is full? */
	if (esmftrc_packet_is_full(ctx)) {
		/* yes: is back-end full? */
		if (ctx->cbs.is_backend_full(ctx->data)) {
			/* yes: discard event */
			ctx->events_discarded++;

			return 0;
		}

		/* back-end is not full: open new packet */
		ctx->cbs.open_packet(ctx->data);
	}

	/* event fits the current packet? */
	if (ev_size > (ctx->packet_size - ctx->at)) {
		/* no: close packet now */
		ctx->cbs.close_packet(ctx->data);

		/* is back-end full? */
		if (ctx->cbs.is_backend_full(ctx->data)) {
			/* yes: discard event */
			ctx->events_discarded++;

			return 0;
		}

		/* back-end is not full: open new packet */
		ctx->cbs.open_packet(ctx->data);
		assert(ev_size <= (ctx->packet_size - ctx->at));
	}

	return 1;
}

static
void _commit_event(void *vctx)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);

	/* is packet full? */
	if (esmftrc_packet_is_full(ctx)) {
		/* yes: close it now */
		ctx->cbs.close_packet(ctx->data);
	}
}

/* initialize context */
void esmftrc_init(
	void *vctx,
	uint8_t *buf,
	uint32_t buf_size,
	struct esmftrc_platform_callbacks cbs,
	void *data
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	ctx->cbs = cbs;
	ctx->data = data;
	ctx->buf = buf;
	ctx->packet_size = _BYTES_TO_BITS(buf_size);
	ctx->at = 0;
	ctx->events_discarded = 0;
	ctx->packet_is_open = 0;
}

/* open packet for stream "default" */
void esmftrc_default_open_packet(
	struct esmftrc_default_ctx *ctx,
	const char * spc_nodename,
	uint32_t spc_pet
)
{
	uint64_t ts = ctx->parent.cbs.sys_clock_clock_get_value(ctx->parent.data);

	/* do not open a packet that is already open */
	if (ctx->parent.packet_is_open) {
		return;
	}

	ctx->parent.at = 0;

	/* trace packet header */
	{
		/* align structure */
		_ALIGN(ctx->parent.at, 32);

		/* "magic" field */
		_ALIGN(ctx->parent.at, 32);
		esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 32, uint32_t, (uint32_t) 0xc1fc1fc1UL);
		(&ctx->parent)->at += 32;

		/* "uuid" field */
		{
			static uint8_t uuid[] = {
				33,
				196,
				224,
				120,
				165,
				199,
				17,
				232,
				133,
				41,
				52,
				243,
				154,
				234,
				173,
				48,
			};

			_ALIGN(ctx->parent.at, 8);
			memcpy(&ctx->parent.buf[_BITS_TO_BYTES(ctx->parent.at)], uuid, 16);
			ctx->parent.at += _BYTES_TO_BITS(16);
		}
	}

	/* stream packet context */
	{
		/* align structure */
		_ALIGN(ctx->parent.at, 64);

		/* "timestamp_begin" field */
		_ALIGN(ctx->parent.at, 64);
		esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 64, uint64_t, (uint64_t) (uint64_t) ts);
		(&ctx->parent)->at += 64;

		/* "timestamp_end" field */
		_ALIGN(ctx->parent.at, 64);
		ctx->off_spc_timestamp_end = ctx->parent.at;
		ctx->parent.at += 64;

		/* "packet_size" field */
		_ALIGN(ctx->parent.at, 32);
		esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 32, uint32_t, (uint32_t) (uint32_t) ctx->parent.packet_size);
		(&ctx->parent)->at += 32;

		/* "content_size" field */
		_ALIGN(ctx->parent.at, 32);
		ctx->off_spc_content_size = ctx->parent.at;
		ctx->parent.at += 32;

		/* "nodename" field */
		_ALIGN(ctx->parent.at, 8);
		_write_cstring((&ctx->parent), spc_nodename);

		/* "pet" field */
		_ALIGN(ctx->parent.at, 32);
		esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 32, uint32_t, (uint32_t) spc_pet);
		(&ctx->parent)->at += 32;
	}

	ctx->parent.off_content = ctx->parent.at;

	/* mark current packet as open */
	ctx->parent.packet_is_open = 1;
}

/* close packet for stream "default" */
void esmftrc_default_close_packet(struct esmftrc_default_ctx *ctx)
{
	uint64_t ts = ctx->parent.cbs.sys_clock_clock_get_value(ctx->parent.data);

	/* do not close a packet that is not open */
	if (!ctx->parent.packet_is_open) {
		return;
	}

	/* save content size */
	ctx->parent.content_size = ctx->parent.at;

	/* "timestamp_end" field */
	ctx->parent.at = ctx->off_spc_timestamp_end;
	esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 64, uint64_t, (uint64_t) (uint64_t) ts);
	(&ctx->parent)->at += 64;

	/* "content_size" field */
	ctx->parent.at = ctx->off_spc_content_size;
	esmftrc_bt_bitfield_write_le(&(&ctx->parent)->buf[_BITS_TO_BYTES((&ctx->parent)->at)], uint8_t, 0, 32, uint32_t, (uint32_t) (uint32_t) ctx->parent.content_size);
	(&ctx->parent)->at += 32;

	/* go back to end of packet */
	ctx->parent.at = ctx->parent.packet_size;

	/* mark packet as closed */
	ctx->parent.packet_is_open = 0;
}

static void _serialize_stream_event_header_default(
	void *vctx,
	uint32_t event_id
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint64_t ts = ctx->cbs.sys_clock_clock_get_value(ctx->data);

	{
		/* align structure */
		_ALIGN(ctx->at, 64);

		/* "id" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) (uint8_t) event_id);
		ctx->at += 8;

		/* "timestamp" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) (uint64_t) ts);
		ctx->at += 64;
	}

}

static uint32_t _get_event_size_default_prologue_enter(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "vmid" field */
		/* field size: 16 (partial total so far: 144) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "method" field */
		/* field size: 8 (partial total so far: 168) */

		/* "phase" field */
		/* field size: 8 (partial total so far: 176) */
	}

	at += 176;

	return at - ctx->at;
}

static void _serialize_event_default_prologue_enter(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 0);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "method" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_method);
		ctx->at += 8;

		/* "phase" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_phase);
		ctx->at += 8;
	}

}

/* trace (stream "default", event "prologue_enter") */
void esmftrc_default_trace_prologue_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_prologue_enter(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_prologue_enter(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_epilogue_exit(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "vmid" field */
		/* field size: 16 (partial total so far: 144) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "method" field */
		/* field size: 8 (partial total so far: 168) */

		/* "phase" field */
		/* field size: 8 (partial total so far: 176) */
	}

	at += 176;

	return at - ctx->at;
}

static void _serialize_event_default_epilogue_exit(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 1);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "method" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_method);
		ctx->at += 8;

		/* "phase" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_phase);
		ctx->at += 8;
	}

}

/* trace (stream "default", event "epilogue_exit") */
void esmftrc_default_trace_epilogue_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_epilogue_exit(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_epilogue_exit(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_phase_enter(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "vmid" field */
		/* field size: 16 (partial total so far: 144) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "method" field */
		/* field size: 8 (partial total so far: 168) */

		/* "phase" field */
		/* field size: 8 (partial total so far: 176) */
	}

	at += 176;

	return at - ctx->at;
}

static void _serialize_event_default_phase_enter(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 2);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "method" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_method);
		ctx->at += 8;

		/* "phase" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_phase);
		ctx->at += 8;
	}

}

/* trace (stream "default", event "phase_enter") */
void esmftrc_default_trace_phase_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_phase_enter(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_phase_enter(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_phase_exit(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "vmid" field */
		/* field size: 16 (partial total so far: 144) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "method" field */
		/* field size: 8 (partial total so far: 168) */

		/* "phase" field */
		/* field size: 8 (partial total so far: 176) */
	}

	at += 176;

	return at - ctx->at;
}

static void _serialize_event_default_phase_exit(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 3);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "method" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_method);
		ctx->at += 8;

		/* "phase" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_phase);
		ctx->at += 8;
	}

}

/* trace (stream "default", event "phase_exit") */
void esmftrc_default_trace_phase_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_phase_exit(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_phase_exit(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_method, ep_phase);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_region_enter(
	void *vctx,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "name" field */
		at += 128;
		at += _BYTES_TO_BITS(strlen(ep_name) + 1);
	}

	return at - ctx->at;
}

static void _serialize_event_default_region_enter(
	void *vctx,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 4);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 8);

		/* "name" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_name);
	}

}

/* trace (stream "default", event "region_enter") */
void esmftrc_default_trace_region_enter(
	struct esmftrc_default_ctx *ctx,
	const char * ep_name
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_region_enter(TO_VOID_PTR(ctx), ep_name);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_region_enter(TO_VOID_PTR(ctx), ep_name);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_region_exit(
	void *vctx,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "name" field */
		at += 128;
		at += _BYTES_TO_BITS(strlen(ep_name) + 1);
	}

	return at - ctx->at;
}

static void _serialize_event_default_region_exit(
	void *vctx,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 5);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 8);

		/* "name" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_name);
	}

}

/* trace (stream "default", event "region_exit") */
void esmftrc_default_trace_region_exit(
	struct esmftrc_default_ctx *ctx,
	const char * ep_name
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_region_exit(TO_VOID_PTR(ctx), ep_name);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_region_exit(TO_VOID_PTR(ctx), ep_name);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_define_region(
	void *vctx,
	uint16_t ep_id,
	uint8_t ep_type,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "id" field */
		/* field size: 16 (partial total so far: 144) */

		/* "type" field */
		/* field size: 8 (partial total so far: 152) */

		/* "vmid" field */
		/* field size: 16 (partial total so far: 176) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 192) */

		/* "method" field */
		/* field size: 8 (partial total so far: 200) */

		/* "phase" field */
		/* field size: 8 (partial total so far: 208) */

		/* "name" field */
		at += 208;
		at += _BYTES_TO_BITS(strlen(ep_name) + 1);
	}

	return at - ctx->at;
}

static void _serialize_event_default_define_region(
	void *vctx,
	uint16_t ep_id,
	uint8_t ep_type,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase,
	const char * ep_name
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 6);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "id" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_id);
		ctx->at += 16;

		/* "type" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_type);
		ctx->at += 8;

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "method" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_method);
		ctx->at += 8;

		/* "phase" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_phase);
		ctx->at += 8;

		/* "name" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_name);
	}

}

/* trace (stream "default", event "define_region") */
void esmftrc_default_trace_define_region(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_id,
	uint8_t ep_type,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase,
	const char * ep_name
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_define_region(TO_VOID_PTR(ctx), ep_id, ep_type, ep_vmid, ep_baseid, ep_method, ep_phase, ep_name);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_define_region(TO_VOID_PTR(ctx), ep_id, ep_type, ep_vmid, ep_baseid, ep_method, ep_phase, ep_name);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_regionid_enter(
	void *vctx,
	uint16_t ep_regionid
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "regionid" field */
		/* field size: 16 (partial total so far: 144) */
	}

	at += 144;

	return at - ctx->at;
}

static void _serialize_event_default_regionid_enter(
	void *vctx,
	uint16_t ep_regionid
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 7);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "regionid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_regionid);
		ctx->at += 16;
	}

}

/* trace (stream "default", event "regionid_enter") */
void esmftrc_default_trace_regionid_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_regionid
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_regionid_enter(TO_VOID_PTR(ctx), ep_regionid);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_regionid_enter(TO_VOID_PTR(ctx), ep_regionid);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_regionid_exit(
	void *vctx,
	uint16_t ep_regionid
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "regionid" field */
		/* field size: 16 (partial total so far: 144) */
	}

	at += 144;

	return at - ctx->at;
}

static void _serialize_event_default_regionid_exit(
	void *vctx,
	uint16_t ep_regionid
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 8);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "regionid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_regionid);
		ctx->at += 16;
	}

}

/* trace (stream "default", event "regionid_exit") */
void esmftrc_default_trace_regionid_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_regionid
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_regionid_exit(TO_VOID_PTR(ctx), ep_regionid);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_regionid_exit(TO_VOID_PTR(ctx), ep_regionid);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_comp(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	const char * ep_name,
	const char * ep_IPM,
	const char * ep_RPM,
	const char * ep_FPM
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "vmid" field */
		/* field size: 16 (partial total so far: 144) */

		/* "baseid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "name" field */
		at += 160;
		at += _BYTES_TO_BITS(strlen(ep_name) + 1);

		/* "IPM" field */
		at += _BYTES_TO_BITS(strlen(ep_IPM) + 1);

		/* "RPM" field */
		at += _BYTES_TO_BITS(strlen(ep_RPM) + 1);

		/* "FPM" field */
		at += _BYTES_TO_BITS(strlen(ep_FPM) + 1);
	}

	return at - ctx->at;
}

static void _serialize_event_default_comp(
	void *vctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	const char * ep_name,
	const char * ep_IPM,
	const char * ep_RPM,
	const char * ep_FPM
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 9);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "vmid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_vmid);
		ctx->at += 16;

		/* "baseid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_baseid);
		ctx->at += 16;

		/* "name" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_name);

		/* "IPM" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_IPM);

		/* "RPM" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_RPM);

		/* "FPM" field */
		_ALIGN(ctx->at, 8);
		_write_cstring(ctx, ep_FPM);
	}

}

/* trace (stream "default", event "comp") */
void esmftrc_default_trace_comp(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	const char * ep_name,
	const char * ep_IPM,
	const char * ep_RPM,
	const char * ep_FPM
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_comp(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_name, ep_IPM, ep_RPM, ep_FPM);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_comp(TO_VOID_PTR(ctx), ep_vmid, ep_baseid, ep_name, ep_IPM, ep_RPM, ep_FPM);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_mem(
	void *vctx,
	uint32_t ep_virtMem,
	uint32_t ep_physMem
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "virtMem" field */
		/* field size: 32 (partial total so far: 160) */

		/* "physMem" field */
		/* field size: 32 (partial total so far: 192) */
	}

	at += 192;

	return at - ctx->at;
}

static void _serialize_event_default_mem(
	void *vctx,
	uint32_t ep_virtMem,
	uint32_t ep_physMem
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 10);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 32);

		/* "virtMem" field */
		_ALIGN(ctx->at, 32);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 32, uint32_t, (uint32_t) ep_virtMem);
		ctx->at += 32;

		/* "physMem" field */
		_ALIGN(ctx->at, 32);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 32, uint32_t, (uint32_t) ep_physMem);
		ctx->at += 32;
	}

}

/* trace (stream "default", event "mem") */
void esmftrc_default_trace_mem(
	struct esmftrc_default_ctx *ctx,
	uint32_t ep_virtMem,
	uint32_t ep_physMem
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_mem(TO_VOID_PTR(ctx), ep_virtMem, ep_physMem);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_mem(TO_VOID_PTR(ctx), ep_virtMem, ep_physMem);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_clk(
	void *vctx,
	uint16_t ep_year,
	uint8_t ep_month,
	uint8_t ep_day,
	uint8_t ep_hour,
	uint8_t ep_minute,
	uint8_t ep_second
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "year" field */
		/* field size: 16 (partial total so far: 144) */

		/* "month" field */
		/* field size: 8 (partial total so far: 152) */

		/* "day" field */
		/* field size: 8 (partial total so far: 160) */

		/* "hour" field */
		/* field size: 8 (partial total so far: 168) */

		/* "minute" field */
		/* field size: 8 (partial total so far: 176) */

		/* "second" field */
		/* field size: 8 (partial total so far: 184) */
	}

	at += 184;

	return at - ctx->at;
}

static void _serialize_event_default_clk(
	void *vctx,
	uint16_t ep_year,
	uint8_t ep_month,
	uint8_t ep_day,
	uint8_t ep_hour,
	uint8_t ep_minute,
	uint8_t ep_second
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 11);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 16);

		/* "year" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_year);
		ctx->at += 16;

		/* "month" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_month);
		ctx->at += 8;

		/* "day" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_day);
		ctx->at += 8;

		/* "hour" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_hour);
		ctx->at += 8;

		/* "minute" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_minute);
		ctx->at += 8;

		/* "second" field */
		_ALIGN(ctx->at, 8);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 8, uint8_t, (uint8_t) ep_second);
		ctx->at += 8;
	}

}

/* trace (stream "default", event "clk") */
void esmftrc_default_trace_clk(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_year,
	uint8_t ep_month,
	uint8_t ep_day,
	uint8_t ep_hour,
	uint8_t ep_minute,
	uint8_t ep_second
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_clk(TO_VOID_PTR(ctx), ep_year, ep_month, ep_day, ep_hour, ep_minute, ep_second);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_clk(TO_VOID_PTR(ctx), ep_year, ep_month, ep_day, ep_hour, ep_minute, ep_second);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_mpiwait(
	void *vctx,
	uint32_t ep_count,
	uint64_t ep_time
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "count" field */
		/* field size: 32 (partial total so far: 160) */

		/* "time" field */
		/* field size: 64 (partial total so far: 256) */
	}

	at += 256;

	return at - ctx->at;
}

static void _serialize_event_default_mpiwait(
	void *vctx,
	uint32_t ep_count,
	uint64_t ep_time
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 12);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 64);

		/* "count" field */
		_ALIGN(ctx->at, 32);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 32, uint32_t, (uint32_t) ep_count);
		ctx->at += 32;

		/* "time" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) ep_time);
		ctx->at += 64;
	}

}

/* trace (stream "default", event "mpiwait") */
void esmftrc_default_trace_mpiwait(
	struct esmftrc_default_ctx *ctx,
	uint32_t ep_count,
	uint64_t ep_time
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_mpiwait(TO_VOID_PTR(ctx), ep_count, ep_time);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_mpiwait(TO_VOID_PTR(ctx), ep_count, ep_time);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}

static uint32_t _get_event_size_default_region_profile(
	void *vctx,
	uint16_t ep_id,
	uint16_t ep_parentid,
	uint64_t ep_total,
	uint64_t ep_self,
	uint32_t ep_count,
	uint64_t ep_max,
	uint64_t ep_min,
	double ep_mean,
	double ep_stddev
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	uint32_t at = ctx->at;

	/* byte-align entity */
	_ALIGN(at, 8);

	/* stream event header */
	{
		/* align structure */
		_ALIGN(at, 64);

		/* "id" field */
		/* field size: 8 (partial total so far: 8) */

		/* "timestamp" field */
		/* field size: 64 (partial total so far: 128) */
	}

	/* event payload */
	{

		/* "id" field */
		/* field size: 16 (partial total so far: 144) */

		/* "parentid" field */
		/* field size: 16 (partial total so far: 160) */

		/* "total" field */
		/* field size: 64 (partial total so far: 256) */

		/* "self" field */
		/* field size: 64 (partial total so far: 320) */

		/* "count" field */
		/* field size: 32 (partial total so far: 352) */

		/* "max" field */
		/* field size: 64 (partial total so far: 448) */

		/* "min" field */
		/* field size: 64 (partial total so far: 512) */

		/* "mean" field */
		/* field size: 64 (partial total so far: 576) */

		/* "stddev" field */
		/* field size: 64 (partial total so far: 640) */
	}

	at += 640;

	return at - ctx->at;
}

static void _serialize_event_default_region_profile(
	void *vctx,
	uint16_t ep_id,
	uint16_t ep_parentid,
	uint64_t ep_total,
	uint64_t ep_self,
	uint32_t ep_count,
	uint64_t ep_max,
	uint64_t ep_min,
	double ep_mean,
	double ep_stddev
)
{
	struct esmftrc_ctx *ctx = FROM_VOID_PTR(struct esmftrc_ctx, vctx);
	/* stream event header */
	_serialize_stream_event_header_default(ctx, 13);

	/* event payload */
	{
		/* align structure */
		_ALIGN(ctx->at, 64);

		/* "id" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_id);
		ctx->at += 16;

		/* "parentid" field */
		_ALIGN(ctx->at, 16);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 16, uint16_t, (uint16_t) ep_parentid);
		ctx->at += 16;

		/* "total" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) ep_total);
		ctx->at += 64;

		/* "self" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) ep_self);
		ctx->at += 64;

		/* "count" field */
		_ALIGN(ctx->at, 32);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 32, uint32_t, (uint32_t) ep_count);
		ctx->at += 32;

		/* "max" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) ep_max);
		ctx->at += 64;

		/* "min" field */
		_ALIGN(ctx->at, 64);
		esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) ep_min);
		ctx->at += 64;

		/* "mean" field */
		_ALIGN(ctx->at, 64);

		{
			union d2u d2u;

			d2u.f = ep_mean;
			esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) d2u.u);
		}

		ctx->at += 64;

		/* "stddev" field */
		_ALIGN(ctx->at, 64);

		{
			union d2u d2u;

			d2u.f = ep_stddev;
			esmftrc_bt_bitfield_write_le(&ctx->buf[_BITS_TO_BYTES(ctx->at)], uint8_t, 0, 64, uint64_t, (uint64_t) d2u.u);
		}

		ctx->at += 64;
	}

}

/* trace (stream "default", event "region_profile") */
void esmftrc_default_trace_region_profile(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_id,
	uint16_t ep_parentid,
	uint64_t ep_total,
	uint64_t ep_self,
	uint32_t ep_count,
	uint64_t ep_max,
	uint64_t ep_min,
	double ep_mean,
	double ep_stddev
)
{
	uint32_t ev_size;

	/* get event size */
	ev_size = _get_event_size_default_region_profile(TO_VOID_PTR(ctx), ep_id, ep_parentid, ep_total, ep_self, ep_count, ep_max, ep_min, ep_mean, ep_stddev);

	/* do we have enough space to serialize? */
	if (!_reserve_event_space(TO_VOID_PTR(ctx), ev_size)) {
		/* no: forget this */
		return;
	}

	/* serialize event */
	_serialize_event_default_region_profile(TO_VOID_PTR(ctx), ep_id, ep_parentid, ep_total, ep_self, ep_count, ep_max, ep_min, ep_mean, ep_stddev);

	/* commit event */
	_commit_event(TO_VOID_PTR(ctx));
}
