/* *****************************************************************
    MESQUITE -- The Mesh Quality Improvement Toolkit

    Copyright 2009 Sandia National Laboratories.  Developed at the
    University of Wisconsin--Madison under SNL contract number
    624796.  The U.S. Government and the University of Wisconsin
    retain certain rights to this software.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    (lgpl.txt) along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    (2009) kraftche@cae.wisc.edu

  ***************************************************************** */

/** \file TShape3DB2.hpp
 *  \brief
 *  \author Jason Kraftcheck
 */

#ifndef MSQ_T_SHAPE_3D_B_2_HPP
#define MSQ_T_SHAPE_3D_B_2_HPP

#include "Mesquite.hpp"
#include "TMetricBarrier.hpp"

namespace MBMesquite
{

/**\brief 3.3.8: 1/9 \Kappa^2(T) - 1,
 *                Kappa(T) = |T||T|^-1 = |T||adj(T)/\tau
 *
 * A target metric for volume elements that optimizes
 * element shape
 */
class TShape3DB2 : public TMetricBarrier3D
{
  public:
    MESQUITE_EXPORT virtual ~TShape3DB2();

    MESQUITE_EXPORT virtual std::string get_name() const;

    MESQUITE_EXPORT virtual bool evaluate( const MsqMatrix< 3, 3 >& T, double& result, MsqError& err );

    MESQUITE_EXPORT virtual bool evaluate_with_grad( const MsqMatrix< 3, 3 >& T, double& result,
                                                     MsqMatrix< 3, 3 >& wrt_T, MsqError& err );

    MESQUITE_EXPORT virtual bool evaluate_with_hess( const MsqMatrix< 3, 3 >& T, double& result,
                                                     MsqMatrix< 3, 3 >& deriv_wrt_T, MsqMatrix< 3, 3 > second_wrt_T[6],
                                                     MsqError& err );
};

}  // namespace MBMesquite

#endif
