//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/main/extension_entries.hpp
//
//
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/common/unordered_map.hpp"
#include "duckdb/common/enums/catalog_type.hpp"

// NOTE: this file is generated by scripts/generate_extensions_function.py.
// Example usage to refresh one extension (replace "icu" with the desired extension):
// GENERATE_EXTENSION_ENTRIES=1 make debug
// python3 scripts/generate_extensions_function.py --extensions icu --shell build/debug/duckdb --extension_repository
// build/debug/repository

// Check out the check-load-install-extensions  job in .github/workflows/LinuxRelease.yml for more details

namespace duckdb {

struct ExtensionEntry {
	char name[48];
	char extension[48];
};

struct ExtensionFunctionEntry {
	char name[48];
	char extension[48];
	CatalogType type;
};

struct ExtensionFunctionOverloadEntry {
	char name[48];
	char extension[48];
	CatalogType type;
	char signature[96];
};

static constexpr ExtensionFunctionEntry EXTENSION_FUNCTIONS[] = {
    {"!__postfix", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"&", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"&&", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"**", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"->>", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"<->", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"<<", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"<<=", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"<=>", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"<@", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {">>", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {">>=", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"@", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"@>", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"^", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"^@", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"abs", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"acos", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"acosh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"add_numbers_together", "demo_capi", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"add_parquet_key", "parquet", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"aggregate", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"alias", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"apply", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"approx_count_distinct", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"approx_quantile", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"approx_top_k", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"arg_max", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"arg_max_null", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"arg_min", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"arg_min_null", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"argmax", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"argmin", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"array_agg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"array_aggr", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_aggregate", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_apply", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_cosine_distance", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_cosine_similarity", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_cross_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_distance", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_distinct", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_dot_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_filter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_grade_up", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_has_all", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_has_any", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_inner_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_negative_dot_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_negative_inner_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_reduce", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_reverse_sort", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_slice", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_sort", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_to_json", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_transform", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_unique", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"array_value", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ascii", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"asin", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"asinh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"atan", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"atan2", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"atanh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"avg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bar", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"base64", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"bin", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"bit_and", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bit_count", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"bit_or", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bit_position", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"bit_xor", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bitstring", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"bitstring_agg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bool_and", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"bool_or", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"broadcast", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"can_cast_implicitly", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"cardinality", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"cast_to_type", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"cbrt", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ceil", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ceiling", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"check_peg_parser", "autocomplete", CatalogType::TABLE_FUNCTION_ENTRY},
    {"chr", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"corr", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"cos", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"cosh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"cot", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"count_if", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"countif", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"covar_pop", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"covar_samp", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"create_fts_index", "fts", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"current_database", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_date", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_localtime", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_localtimestamp", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_query", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_schema", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_schemas", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"current_setting", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"damerau_levenshtein", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"dbgen", "tpch", CatalogType::TABLE_FUNCTION_ENTRY},
    {"decode", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"degrees", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"delta_scan", "delta", CatalogType::TABLE_FUNCTION_ENTRY},
    {"drop_fts_index", "fts", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"dsdgen", "tpcds", CatalogType::TABLE_FUNCTION_ENTRY},
    {"duckdb_proj_compiled_version", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"duckdb_proj_version", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ducklake_add_data_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_cleanup_old_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_current_snapshot", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_delete_orphaned_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_expire_snapshots", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_flush_inlined_data", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_last_committed_snapshot", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_list_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_merge_adjacent_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_options", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_rewrite_data_files", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_set_commit_message", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_set_option", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_snapshots", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_table_changes", "ducklake", CatalogType::TABLE_MACRO_ENTRY},
    {"ducklake_table_deletions", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_table_info", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"ducklake_table_insertions", "ducklake", CatalogType::TABLE_FUNCTION_ENTRY},
    {"editdist3", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"element_at", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"encode", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"entropy", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"enum_code", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"enum_first", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"enum_last", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"enum_range", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"enum_range_boundary", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"epoch_ms", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"epoch_ns", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"epoch_us", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"equi_width_bins", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"even", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"excel_text", "excel", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"exp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"factorial", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"family", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"favg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"filter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"flatten", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"floor", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"format", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"format_bytes", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"formatreadabledecimalsize", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"formatreadablesize", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"from_base64", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"from_binary", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"from_hex", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"from_json", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"from_json_strict", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"fsum", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"fuzz_all_functions", "sqlsmith", CatalogType::TABLE_FUNCTION_ENTRY},
    {"fuzzyduck", "sqlsmith", CatalogType::TABLE_FUNCTION_ENTRY},
    {"gamma", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"gcd", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"gen_random_uuid", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"get_bit", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"get_current_time", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"get_current_timestamp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"grade_up", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"greatest", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"greatest_common_divisor", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"group_concat", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"hamming", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"hash", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"hex", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"histogram", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"histogram_exact", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"hnsw_compact_index", "vss", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"hnsw_index_scan", "vss", CatalogType::TABLE_FUNCTION_ENTRY},
    {"host", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"html_escape", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"html_unescape", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"iceberg_metadata", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"iceberg_scan", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"iceberg_snapshots", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"iceberg_table_properties", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"iceberg_to_ducklake", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"icu_calendar_names", "icu", CatalogType::TABLE_FUNCTION_ENTRY},
    {"icu_collate_af", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_am", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ar", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ar_sa", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_as", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_az", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_be", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_bg", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_bn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_bo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_br", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_bs", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ca", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ceb", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_chr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_cs", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_cy", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_da", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_de", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_de_at", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_dsb", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_dz", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ee", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_el", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_en", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_en_us", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_eo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_es", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_et", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fa", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fa_af", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ff", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fi", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fil", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fr_ca", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_fy", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ga", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_gl", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_gu", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ha", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_haw", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_he", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_he_il", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_hi", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_hr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_hsb", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_hu", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_hy", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_id", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_id_id", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ig", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_is", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_it", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ja", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ka", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_kk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_kl", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_km", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_kn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ko", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_kok", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ku", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ky", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_lb", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_lkt", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ln", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_lo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_lt", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_lv", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_mk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ml", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_mn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_mr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ms", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_mt", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_my", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_nb", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_nb_no", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ne", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_nl", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_nn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_noaccent", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_om", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_or", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_pa", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_pa_in", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_pl", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ps", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_pt", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ro", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ru", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sa", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_se", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_si", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sl", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_smn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sq", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sr_ba", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sr_me", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sr_rs", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sv", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_sw", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ta", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_te", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_th", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_tk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_to", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_tr", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ug", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_uk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_ur", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_uz", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_vi", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_wae", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_wo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_xh", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_yi", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_yo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_yue", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_yue_cn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh_cn", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh_hk", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh_mo", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh_sg", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zh_tw", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_collate_zu", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"icu_sort_key", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"in_search_path", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"instr", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"is_histogram_other_bin", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"isfinite", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"isinf", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"isnan", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"jaccard", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"jaro_similarity", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"jaro_winkler_similarity", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json", "json", CatalogType::MACRO_ENTRY},
    {"json_array", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_array_length", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_contains", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_deserialize_sql", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_each", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"json_execute_serialized_sql", "json", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"json_execute_serialized_sql", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"json_exists", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_extract", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_extract_path", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_extract_path_text", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_extract_string", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_group_array", "json", CatalogType::MACRO_ENTRY},
    {"json_group_object", "json", CatalogType::MACRO_ENTRY},
    {"json_group_structure", "json", CatalogType::MACRO_ENTRY},
    {"json_keys", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_merge_patch", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_object", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_pretty", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_quote", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_serialize_plan", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_serialize_sql", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_structure", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_transform", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_transform_strict", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_tree", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"json_type", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_valid", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"json_value", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"kahan_sum", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"kurtosis", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"kurtosis_pop", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"lcm", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"least", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"least_common_multiple", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"left", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"left_grapheme", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"levenshtein", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"lgamma", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"list_aggr", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_aggregate", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_apply", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_cosine_distance", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_cosine_similarity", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_distance", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_distinct", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_dot_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_filter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_grade_up", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_has_all", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_has_any", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_inner_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_negative_dot_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_negative_inner_product", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_pack", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_reduce", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_reverse_sort", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_slice", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_sort", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_transform", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_unique", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"list_value", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"listagg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"ln", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"load_aws_credentials", "aws", CatalogType::TABLE_FUNCTION_ENTRY},
    {"log", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"log10", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"log2", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"lpad", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ltrim", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"mad", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"make_date", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"make_time", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"make_timestamp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"make_timestamp_ms", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"make_timestamp_ns", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"make_timestamptz", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_concat", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_entries", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_extract", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_extract_value", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_from_entries", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_keys", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"map_values", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"max_by", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"mean", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"median", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"min_by", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"mismatches", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"mode", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"mysql_clear_cache", "mysql_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"mysql_execute", "mysql_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"mysql_query", "mysql_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"nanosecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"netmask", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"network", "inet", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"nextafter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"normalized_interval", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"now", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ord", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"parquet_bloom_probe", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parquet_file_metadata", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parquet_kv_metadata", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parquet_metadata", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parquet_scan", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parquet_schema", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"parse_dirname", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"parse_dirpath", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"parse_filename", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"parse_path", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"pg_clear_cache", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"pg_timezone_names", "icu", CatalogType::TABLE_FUNCTION_ENTRY},
    {"pi", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"position", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"postgres_attach", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"postgres_execute", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"postgres_query", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"postgres_scan", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"postgres_scan_pushdown", "postgres_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"pow", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"power", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"pragma_hnsw_index_info", "vss", CatalogType::TABLE_FUNCTION_ENTRY},
    {"pragma_rtree_index_info", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"printf", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"product", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"quantile", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"quantile_cont", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"quantile_disc", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"radians", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"random", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"read_avro", "avro", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_json", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_json_auto", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_json_objects", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_json_objects_auto", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_ndjson", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_ndjson_auto", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_ndjson_objects", "json", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_parquet", "parquet", CatalogType::TABLE_FUNCTION_ENTRY},
    {"read_xlsx", "excel", CatalogType::TABLE_FUNCTION_ENTRY},
    {"reduce", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"reduce_sql_statement", "sqlsmith", CatalogType::TABLE_FUNCTION_ENTRY},
    {"register_geoarrow_extensions", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"regr_avgx", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_avgy", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_count", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_intercept", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_r2", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_slope", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_sxx", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_sxy", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"regr_syy", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"remove_iceberg_table_properties", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"repeat", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"replace", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"replace_type", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"reservoir_quantile", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"reverse", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"right", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"right_grapheme", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"round", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"row_to_json", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"rpad", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"rtree_index_dump", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"rtree_index_scan", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"rtrim", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"sem", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"set_bit", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"set_iceberg_table_properties", "iceberg", CatalogType::TABLE_FUNCTION_ENTRY},
    {"setseed", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"shapefile_meta", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sign", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"signbit", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"sin", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"sinh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"skewness", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"sql_auto_complete", "autocomplete", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sqlite_attach", "sqlite_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sqlite_query", "sqlite_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sqlite_scan", "sqlite_scanner", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sqlsmith", "sqlsmith", CatalogType::TABLE_FUNCTION_ENTRY},
    {"sqrt", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_affine", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_area", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_area_spheroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_asgeojson", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_ashexwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_asmvt", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_asmvtgeom", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_assvg", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_astext", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_aswkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_azimuth", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_boundary", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_buffer", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_buildarea", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_centroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_collect", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_collectionextract", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_concavehull", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_contains", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_containsproperly", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_convexhull", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_coverageinvalidedges", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_coverageinvalidedges_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_coveragesimplify", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_coveragesimplify_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_coverageunion", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_coverageunion_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_coveredby", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_covers", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_crosses", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_difference", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_dimension", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_disjoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_distance", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_distance_geos", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_distance_sphere", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_distance_spheroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_drivers", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_dump", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_dwithin", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_dwithin_geos", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_dwithin_spheroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_endpoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_envelope", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_envelope_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_equals", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_expand", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_extent", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_extent_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_extent_approx", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_exteriorring", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_flipcoordinates", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_force2d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_force3dm", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_force3dz", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_force4d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_generatepoints", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_geometrytype", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_geomfromgeojson", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_geomfromhexewkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_geomfromhexwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_geomfromtext", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_geomfromwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_hasm", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_hasz", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_hilbert", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_interiorringn", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_interpolatepoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_intersection", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_intersection_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_intersects", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_intersects_extent", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_isclosed", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_isempty", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_isring", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_issimple", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_isvalid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_length", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_length_spheroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_lineinterpolatepoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_lineinterpolatepoints", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_linelocatepoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_linemerge", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_linestring2dfromwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_linesubstring", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_locatealong", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_locatebetween", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_m", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makebox2d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makeenvelope", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makeline", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makepoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makepolygon", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_makevalid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_maximuminscribedcircle", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_memunion_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_minimumrotatedrectangle", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_mmax", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_mmin", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_multi", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_ngeometries", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_ninteriorrings", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_node", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_normalize", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_npoints", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_numgeometries", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_numinteriorrings", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_numpoints", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_overlaps", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_perimeter", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_perimeter_spheroid", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_point", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_point2d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_point2dfromwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_point3d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_point4d", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_pointn", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_pointonsurface", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_points", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_polygon2dfromwkb", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_polygonize", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_quadkey", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_read", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_read_meta", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_readosm", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_readshp", "spatial", CatalogType::TABLE_FUNCTION_ENTRY},
    {"st_reduceprecision", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_removerepeatedpoints", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_reverse", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_rotate", "spatial", CatalogType::MACRO_ENTRY},
    {"st_rotatex", "spatial", CatalogType::MACRO_ENTRY},
    {"st_rotatey", "spatial", CatalogType::MACRO_ENTRY},
    {"st_rotatez", "spatial", CatalogType::MACRO_ENTRY},
    {"st_scale", "spatial", CatalogType::MACRO_ENTRY},
    {"st_shortestline", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_simplify", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_simplifypreservetopology", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_startpoint", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_tileenvelope", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_touches", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_transform", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_translate", "spatial", CatalogType::MACRO_ENTRY},
    {"st_transscale", "spatial", CatalogType::MACRO_ENTRY},
    {"st_union", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_union_agg", "spatial", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"st_voronoidiagram", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_within", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_withinproperly", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_x", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_xmax", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_xmin", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_y", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_ymax", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_ymin", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_z", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_zmax", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_zmflag", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"st_zmin", "spatial", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"start_ui", "ui", CatalogType::TABLE_FUNCTION_ENTRY},
    {"start_ui_server", "ui", CatalogType::TABLE_FUNCTION_ENTRY},
    {"starts_with", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"stats", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"stddev", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"stddev_pop", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"stddev_samp", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"stem", "fts", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"stop_ui_server", "ui", CatalogType::TABLE_FUNCTION_ENTRY},
    {"string_agg", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"strpos", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"struct_insert", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"struct_update", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"sum", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"sum_no_overflow", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"sumkahan", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"tan", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"tanh", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"text", "excel", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"timetz_byte_comparable", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_base", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_base64", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_binary", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_centuries", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_days", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_decades", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_hex", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_hours", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_json", "json", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_microseconds", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_millennia", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_milliseconds", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_minutes", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_months", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_quarters", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_seconds", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_timestamp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_weeks", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"to_years", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"today", "icu", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"tpcds", "tpcds", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"tpcds_answers", "tpcds", CatalogType::TABLE_FUNCTION_ENTRY},
    {"tpcds_queries", "tpcds", CatalogType::TABLE_FUNCTION_ENTRY},
    {"tpch", "tpch", CatalogType::PRAGMA_FUNCTION_ENTRY},
    {"tpch_answers", "tpch", CatalogType::TABLE_FUNCTION_ENTRY},
    {"tpch_queries", "tpch", CatalogType::TABLE_FUNCTION_ENTRY},
    {"transaction_timestamp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"translate", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"trim", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"trunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"txid_current", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"typeof", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"ui_is_started", "ui", CatalogType::TABLE_FUNCTION_ENTRY},
    {"unbin", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"unhex", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"unicode", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"union_extract", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"union_tag", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"union_value", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"unpivot_list", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"url_decode", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"url_encode", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"uuid", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"uuid_extract_timestamp", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"uuid_extract_version", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"uuidv4", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"uuidv7", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"var_pop", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"var_samp", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"variance", "core_functions", CatalogType::AGGREGATE_FUNCTION_ENTRY},
    {"vector_type", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"version", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"vss_join", "vss", CatalogType::TABLE_MACRO_ENTRY},
    {"vss_match", "vss", CatalogType::TABLE_MACRO_ENTRY},
    {"xor", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"|", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
    {"~", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY},
}; // END_OF_EXTENSION_FUNCTIONS

static constexpr ExtensionFunctionOverloadEntry EXTENSION_FUNCTION_OVERLOADS[] = {
    {"age", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>INTERVAL"},
    {"age", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP,TIMESTAMP]>INTERVAL"},
    {"age", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>INTERVAL"},
    {"age", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ,TIMESTAMPTZ]>INTERVAL"},
    {"century", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"century", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"century", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"century", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"date_diff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE,DATE]>BIGINT"},
    {"date_diff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME,TIME]>BIGINT"},
    {"date_diff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP,TIMESTAMP]>BIGINT"},
    {"date_diff", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ,TIMESTAMPTZ]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',DATE]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',INTERVAL]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIME]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMESTAMP]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMETZ]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIME_NS]>STRUCT()"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,INTERVAL]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMETZ]>BIGINT"},
    {"date_part", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME_NS]>BIGINT"},
    {"date_part", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMESTAMPTZ]>STRUCT()"},
    {"date_part", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ]>BIGINT"},
    {"date_sub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE,DATE]>BIGINT"},
    {"date_sub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME,TIME]>BIGINT"},
    {"date_sub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP,TIMESTAMP]>BIGINT"},
    {"date_sub", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ,TIMESTAMPTZ]>BIGINT"},
    {"date_trunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE]>TIMESTAMP"},
    {"date_trunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,INTERVAL]>INTERVAL"},
    {"date_trunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP]>TIMESTAMP"},
    {"date_trunc", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ]>TIMESTAMPTZ"},
    {"datediff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE,DATE]>BIGINT"},
    {"datediff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME,TIME]>BIGINT"},
    {"datediff", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP,TIMESTAMP]>BIGINT"},
    {"datediff", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ,TIMESTAMPTZ]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',DATE]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',INTERVAL]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIME]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMESTAMP]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMETZ]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIME_NS]>STRUCT()"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,INTERVAL]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMETZ]>BIGINT"},
    {"datepart", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME_NS]>BIGINT"},
    {"datepart", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "['VARCHAR[]',TIMESTAMPTZ]>STRUCT()"},
    {"datepart", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ]>BIGINT"},
    {"datesub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE,DATE]>BIGINT"},
    {"datesub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIME,TIME]>BIGINT"},
    {"datesub", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP,TIMESTAMP]>BIGINT"},
    {"datesub", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ,TIMESTAMPTZ]>BIGINT"},
    {"datetrunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,DATE]>TIMESTAMP"},
    {"datetrunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,INTERVAL]>INTERVAL"},
    {"datetrunc", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP]>TIMESTAMP"},
    {"datetrunc", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ]>TIMESTAMPTZ"},
    {"day", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"day", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"day", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"day", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"dayname", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>VARCHAR"},
    {"dayname", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>VARCHAR"},
    {"dayname", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>VARCHAR"},
    {"dayofmonth", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"dayofmonth", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"dayofmonth", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"dayofmonth", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"dayofweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"dayofweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"dayofweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"dayofweek", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"dayofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"dayofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"dayofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"dayofyear", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"decade", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"decade", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"decade", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"decade", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>DOUBLE"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>DOUBLE"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>DOUBLE"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>DOUBLE"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>DOUBLE"},
    {"epoch", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>DOUBLE"},
    {"epoch", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>DOUBLE"},
    {"era", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"era", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"era", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"era", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"generate_series", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT]>BIGINT[]"},
    {"generate_series", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT,BIGINT]>BIGINT[]"},
    {"generate_series", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT,BIGINT,BIGINT]>BIGINT[]"},
    {"generate_series", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY,
     "[TIMESTAMP,TIMESTAMP,INTERVAL]>TIMESTAMP[]"},
    {"generate_series", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ,TIMESTAMPTZ,INTERVAL]>TIMESTAMPTZ[]"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>BIGINT"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>BIGINT"},
    {"hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>BIGINT"},
    {"hour", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"isodow", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"isodow", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"isodow", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"isodow", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"isoyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"isoyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"isoyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"isoyear", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"julian", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>DOUBLE"},
    {"julian", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>DOUBLE"},
    {"julian", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>DOUBLE"},
    {"last_day", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>DATE"},
    {"last_day", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>DATE"},
    {"last_day", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>DATE"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>BIGINT"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>BIGINT"},
    {"microsecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>BIGINT"},
    {"microsecond", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"millennium", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"millennium", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"millennium", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"millennium", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>BIGINT"},
    {"millisecond", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>BIGINT"},
    {"millisecond", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>BIGINT"},
    {"minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>BIGINT"},
    {"minute", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"month", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"month", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"month", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"month", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"monthname", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>VARCHAR"},
    {"monthname", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>VARCHAR"},
    {"monthname", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>VARCHAR"},
    {"quarter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"quarter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"quarter", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"quarter", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"range", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT]>BIGINT[]"},
    {"range", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT,BIGINT]>BIGINT[]"},
    {"range", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[BIGINT,BIGINT,BIGINT]>BIGINT[]"},
    {"range", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP,TIMESTAMP,INTERVAL]>TIMESTAMP[]"},
    {"range", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ,TIMESTAMPTZ,INTERVAL]>TIMESTAMPTZ[]"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME]>BIGINT"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMETZ]>BIGINT"},
    {"second", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIME_NS]>BIGINT"},
    {"second", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,DATE]>DATE"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,DATE,DATE]>DATE"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,DATE,INTERVAL]>DATE"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMP]>TIMESTAMP"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMP,INTERVAL]>TIMESTAMP"},
    {"time_bucket", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMP,TIMESTAMP]>TIMESTAMP"},
    {"time_bucket", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMPTZ]>TIMESTAMPTZ"},
    {"time_bucket", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMPTZ,INTERVAL]>TIMESTAMPTZ"},
    {"time_bucket", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMPTZ,TIMESTAMPTZ]>TIMESTAMPTZ"},
    {"time_bucket", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMESTAMPTZ,VARCHAR]>TIMESTAMPTZ"},
    {"timezone", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"timezone", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"timezone", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL,TIMETZ]>TIMETZ"},
    {"timezone", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"timezone", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"timezone", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMP]>TIMESTAMPTZ"},
    {"timezone", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMESTAMPTZ]>TIMESTAMP"},
    {"timezone", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[VARCHAR,TIMETZ]>TIMETZ"},
    {"timezone_hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"timezone_hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"timezone_hour", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"timezone_hour", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"timezone_minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"timezone_minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"timezone_minute", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"timezone_minute", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"week", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"week", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"week", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"week", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"weekday", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"weekday", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"weekday", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"weekday", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"weekofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"weekofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"weekofyear", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"weekofyear", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"year", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"year", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"year", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"year", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
    {"yearweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[DATE]>BIGINT"},
    {"yearweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[INTERVAL]>BIGINT"},
    {"yearweek", "core_functions", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMP]>BIGINT"},
    {"yearweek", "icu", CatalogType::SCALAR_FUNCTION_ENTRY, "[TIMESTAMPTZ]>BIGINT"},
}; // END_OF_EXTENSION_FUNCTION_OVERLOADS

static constexpr ExtensionEntry EXTENSION_SETTINGS[] = {
    {"auto_fallback_to_full_download", "httpfs"},
    {"azure_account_name", "azure"},
    {"azure_context_caching", "azure"},
    {"azure_credential_chain", "azure"},
    {"azure_endpoint", "azure"},
    {"azure_http_proxy", "azure"},
    {"azure_http_stats", "azure"},
    {"azure_proxy_password", "azure"},
    {"azure_proxy_user_name", "azure"},
    {"azure_read_buffer_size", "azure"},
    {"azure_read_transfer_chunk_size", "azure"},
    {"azure_read_transfer_concurrency", "azure"},
    {"azure_storage_connection_string", "azure"},
    {"azure_transport_option_type", "azure"},
    {"binary_as_string", "parquet"},
    {"ca_cert_file", "httpfs"},
    {"calendar", "icu"},
    {"disable_parquet_prefetching", "parquet"},
    {"ducklake_max_retry_count", "ducklake"},
    {"ducklake_retry_backoff", "ducklake"},
    {"ducklake_retry_wait_ms", "ducklake"},
    {"enable_curl_server_cert_verification", "httpfs"},
    {"enable_geoparquet_conversion", "parquet"},
    {"enable_global_s3_configuration", "httpfs"},
    {"enable_server_cert_verification", "httpfs"},
    {"force_download", "httpfs"},
    {"hf_max_per_page", "httpfs"},
    {"hnsw_ef_search", "vss"},
    {"hnsw_enable_experimental_persistence", "vss"},
    {"http_keep_alive", "httpfs"},
    {"http_retries", "httpfs"},
    {"http_retry_backoff", "httpfs"},
    {"http_retry_wait_ms", "httpfs"},
    {"http_timeout", "httpfs"},
    {"httpfs_client_implementation", "httpfs"},
    {"iceberg_via_aws_sdk_for_catalog_interactions", "iceberg"},
    {"merge_http_secret_into_s3_request", "httpfs"},
    {"mysql_bit1_as_boolean", "mysql_scanner"},
    {"mysql_debug_show_queries", "mysql_scanner"},
    {"mysql_experimental_filter_pushdown", "mysql_scanner"},
    {"mysql_session_time_zone", "mysql_scanner"},
    {"mysql_time_as_time", "mysql_scanner"},
    {"mysql_tinyint1_as_boolean", "mysql_scanner"},
    {"parquet_metadata_cache", "parquet"},
    {"pg_array_as_varchar", "postgres_scanner"},
    {"pg_connection_cache", "postgres_scanner"},
    {"pg_connection_limit", "postgres_scanner"},
    {"pg_debug_show_queries", "postgres_scanner"},
    {"pg_experimental_filter_pushdown", "postgres_scanner"},
    {"pg_null_byte_replacement", "postgres_scanner"},
    {"pg_pages_per_task", "postgres_scanner"},
    {"pg_use_binary_copy", "postgres_scanner"},
    {"pg_use_ctid_scan", "postgres_scanner"},
    {"pg_use_text_protocol", "postgres_scanner"},
    {"prefetch_all_parquet_files", "parquet"},
    {"s3_access_key_id", "httpfs"},
    {"s3_endpoint", "httpfs"},
    {"s3_kms_key_id", "httpfs"},
    {"s3_region", "httpfs"},
    {"s3_requester_pays", "httpfs"},
    {"s3_secret_access_key", "httpfs"},
    {"s3_session_token", "httpfs"},
    {"s3_uploader_max_filesize", "httpfs"},
    {"s3_uploader_max_parts_per_file", "httpfs"},
    {"s3_uploader_thread_limit", "httpfs"},
    {"s3_url_compatibility_mode", "httpfs"},
    {"s3_url_style", "httpfs"},
    {"s3_use_ssl", "httpfs"},
    {"sqlite_all_varchar", "sqlite_scanner"},
    {"sqlite_debug_show_queries", "sqlite_scanner"},
    {"timezone", "icu"},
    {"ui_local_port", "ui"},
    {"ui_polling_interval", "ui"},
    {"ui_remote_url", "ui"},
    {"unsafe_disable_etag_checks", "httpfs"},
    {"unsafe_enable_version_guessing", "iceberg"},
    {"variant_legacy_encoding", "parquet"},
}; // END_OF_EXTENSION_SETTINGS

static constexpr ExtensionEntry EXTENSION_SECRET_TYPES[] = {
    {"aws", "httpfs"},         {"azure", "azure"},     {"ducklake", "ducklake"},   {"gcs", "httpfs"},
    {"huggingface", "httpfs"}, {"iceberg", "iceberg"}, {"mysql", "mysql_scanner"}, {"postgres", "postgres_scanner"},
    {"r2", "httpfs"},          {"s3", "httpfs"},
}; // END_OF_EXTENSION_SECRET_TYPES

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_COPY_FUNCTIONS[] = {
    {"parquet", "parquet"}, {"json", "json"}, {"avro", "avro"}}; // END_OF_EXTENSION_COPY_FUNCTIONS

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_TYPES[] = {
    {"json", "json"}, {"inet", "inet"}, {"geometry", "spatial"}}; // END_OF_EXTENSION_TYPES

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_COLLATIONS[] = {
    {"af", "icu"},    {"am", "icu"},    {"ar", "icu"},     {"ar_sa", "icu"}, {"as", "icu"},    {"az", "icu"},
    {"be", "icu"},    {"bg", "icu"},    {"bn", "icu"},     {"bo", "icu"},    {"br", "icu"},    {"bs", "icu"},
    {"ca", "icu"},    {"ceb", "icu"},   {"chr", "icu"},    {"cs", "icu"},    {"cy", "icu"},    {"da", "icu"},
    {"de", "icu"},    {"de_at", "icu"}, {"dsb", "icu"},    {"dz", "icu"},    {"ee", "icu"},    {"el", "icu"},
    {"en", "icu"},    {"en_us", "icu"}, {"eo", "icu"},     {"es", "icu"},    {"et", "icu"},    {"fa", "icu"},
    {"fa_af", "icu"}, {"ff", "icu"},    {"fi", "icu"},     {"fil", "icu"},   {"fo", "icu"},    {"fr", "icu"},
    {"fr_ca", "icu"}, {"fy", "icu"},    {"ga", "icu"},     {"gl", "icu"},    {"gu", "icu"},    {"ha", "icu"},
    {"haw", "icu"},   {"he", "icu"},    {"he_il", "icu"},  {"hi", "icu"},    {"hr", "icu"},    {"hsb", "icu"},
    {"hu", "icu"},    {"hy", "icu"},    {"id", "icu"},     {"id_id", "icu"}, {"ig", "icu"},    {"is", "icu"},
    {"it", "icu"},    {"ja", "icu"},    {"ka", "icu"},     {"kk", "icu"},    {"kl", "icu"},    {"km", "icu"},
    {"kn", "icu"},    {"ko", "icu"},    {"kok", "icu"},    {"ku", "icu"},    {"ky", "icu"},    {"lb", "icu"},
    {"lkt", "icu"},   {"ln", "icu"},    {"lo", "icu"},     {"lt", "icu"},    {"lv", "icu"},    {"mk", "icu"},
    {"ml", "icu"},    {"mn", "icu"},    {"mr", "icu"},     {"ms", "icu"},    {"mt", "icu"},    {"my", "icu"},
    {"nb", "icu"},    {"nb_no", "icu"}, {"ne", "icu"},     {"nl", "icu"},    {"nn", "icu"},    {"om", "icu"},
    {"or", "icu"},    {"pa", "icu"},    {"pa_in", "icu"},  {"pl", "icu"},    {"ps", "icu"},    {"pt", "icu"},
    {"ro", "icu"},    {"ru", "icu"},    {"sa", "icu"},     {"se", "icu"},    {"si", "icu"},    {"sk", "icu"},
    {"sl", "icu"},    {"smn", "icu"},   {"sq", "icu"},     {"sr", "icu"},    {"sr_ba", "icu"}, {"sr_me", "icu"},
    {"sr_rs", "icu"}, {"sv", "icu"},    {"sw", "icu"},     {"ta", "icu"},    {"te", "icu"},    {"th", "icu"},
    {"tk", "icu"},    {"to", "icu"},    {"tr", "icu"},     {"ug", "icu"},    {"uk", "icu"},    {"ur", "icu"},
    {"uz", "icu"},    {"vi", "icu"},    {"wae", "icu"},    {"wo", "icu"},    {"xh", "icu"},    {"yi", "icu"},
    {"yo", "icu"},    {"yue", "icu"},   {"yue_cn", "icu"}, {"zh", "icu"},    {"zh_cn", "icu"}, {"zh_hk", "icu"},
    {"zh_mo", "icu"}, {"zh_sg", "icu"}, {"zh_tw", "icu"},  {"zu", "icu"}}; // END_OF_EXTENSION_COLLATIONS

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_FILE_PREFIXES[] = {
    {"http://", "httpfs"}, {"https://", "httpfs"}, {"s3://", "httpfs"}, {"s3a://", "httpfs"},  {"s3n://", "httpfs"},
    {"gcs://", "httpfs"},  {"gs://", "httpfs"},    {"r2://", "httpfs"}, {"azure://", "azure"}, {"az://", "azure"},
    {"abfss://", "azure"}, {"hf://", "httpfs"}}; // END_OF_EXTENSION_FILE_PREFIXES

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_FILE_POSTFIXES[] = {
    {".parquet", "parquet"}, {".json", "json"},   {".jsonl", "json"}, {".ndjson", "json"}, {".shp", "spatial"},
    {".gpkg", "spatial"},    {".fgb", "spatial"}, {".xlsx", "excel"}, {".avro", "avro"},
}; // END_OF_EXTENSION_FILE_POSTFIXES

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_FILE_CONTAINS[] = {{".parquet?", "parquet"},
                                                             {".json?", "json"},
                                                             {".ndjson?", ".jsonl?"},
                                                             {".jsonl?", ".ndjson?"}}; // EXTENSION_FILE_CONTAINS

// Note: these are currently hardcoded in scripts/generate_extensions_function.py
// TODO: automate by passing though to script via duckdb
static constexpr ExtensionEntry EXTENSION_SECRET_PROVIDERS[] = {
    {"s3/config", "httpfs"},
    {"gcs/config", "httpfs"},
    {"r2/config", "httpfs"},
    {"s3/credential_chain", "aws"},
    {"gcs/credential_chain", "aws"},
    {"r2/credential_chain", "aws"},
    {"aws/credential_chain", "aws"},
    {"azure/access_token", "azure"},
    {"azure/config", "azure"},
    {"azure/credential_chain", "azure"},
    {"azure/service_principal", "azure"},
    {"huggingface/config", "httfps"},
    {"huggingface/credential_chain", "httpfs"},
    {"bearer/config", "httpfs"},
    {"mysql/config", "mysql_scanner"},
    {"postgres/config", "postgres_scanner"}}; // EXTENSION_SECRET_PROVIDERS

static constexpr const char *AUTOLOADABLE_EXTENSIONS[] = {"avro",
                                                          "aws",
                                                          "azure",
                                                          "autocomplete",
                                                          "core_functions",
                                                          "delta",
                                                          "ducklake",
                                                          "encodings",
                                                          "excel",
                                                          "fts",
                                                          "httpfs",
                                                          "iceberg",
                                                          "inet",
                                                          "icu",
                                                          "json",
                                                          "motherduck",
                                                          "mysql_scanner",
                                                          "parquet",
                                                          "sqlite_scanner",
                                                          "sqlsmith",
                                                          "postgres_scanner",
                                                          "tpcds",
                                                          "tpch",
                                                          "uc_catalog",
                                                          "ui"}; // END_OF_AUTOLOADABLE_EXTENSIONS

} // namespace duckdb
