/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.ui.browser.TooltipService;
import org.apache.commons.lang3.StringUtils;

public class PathTooltipService
implements TooltipService<Path> {
    @Override
    public String getTooltip(Path file) {
        StringBuilder tooltip = new StringBuilder(file.getAbsolute());
        Checksum checksum = file.attributes().getChecksum();
        if (Checksum.NONE != checksum) {
            tooltip.append("\n").append(String.format("%s %s", StringUtils.upperCase((String)checksum.algorithm.name()), checksum.hash));
        }
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            tooltip.append("\n").append(file.attributes().getVersionId());
        }
        return tooltip.toString();
    }
}

