/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;

public class ReadSizeWorker
extends Worker<Long> {
    private final List<Path> files;
    private Long total = 0L;

    public ReadSizeWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public Long run(Session<?> session) throws BackgroundException {
        for (Path next : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            if (-1L == next.attributes().getSize()) continue;
            this.total = this.total + next.attributes().getSize();
        }
        return this.total;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Getting size of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public Long initialize() {
        return this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadSizeWorker that = (ReadSizeWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadSizeWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

