/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class AttributesWorker
extends Worker<PathAttributes> {
    private static final Logger log = Logger.getLogger((String)AttributesWorker.class.getName());
    private final Path file;

    public AttributesWorker(Path file) {
        this.file = file;
    }

    @Override
    public PathAttributes run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Read latest attributes for file %s", this.file));
        }
        AttributesFinder find = session.getFeature(AttributesFinder.class);
        PathAttributes attr = find.find(this.file);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Return %s for file %s", attr, this.file));
        }
        return attr;
    }

    @Override
    public PathAttributes initialize() {
        return PathAttributes.EMPTY;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), this.file.getName());
    }
}

