/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.symlink;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.symlink.AbstractSymlinkResolver;
import java.util.List;
import org.apache.log4j.Logger;

public class UploadSymlinkResolver
extends AbstractSymlinkResolver<Local> {
    private static final Logger log = Logger.getLogger(UploadSymlinkResolver.class);
    private final Symlink feature;
    private final List<TransferItem> files;

    public UploadSymlinkResolver(Symlink feature, List<TransferItem> files) {
        this.feature = feature;
        this.files = files;
    }

    @Override
    public boolean resolve(Local file) throws NotfoundException, LocalAccessDeniedException {
        if (PreferencesFactory.get().getBoolean("local.symboliclink.resolve")) {
            return false;
        }
        if (this.feature != null) {
            Local target = file.getSymlinkTarget();
            for (TransferItem root : this.files) {
                if (!this.findTarget(target, root.local)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Resolved target %s for %s", target, file));
                }
                return true;
            }
        }
        return false;
    }

    private boolean findTarget(Local target, Local root) {
        return target.equals(root) || target.isChild(root);
    }
}

