/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pasteboard;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PathPasteboardFactory {
    private static final Map<Host, PathPasteboard> pasteboards = new HashMap<Host, PathPasteboard>();

    private PathPasteboardFactory() {
    }

    public static PathPasteboard getPasteboard(Host bookmark) {
        if (null == bookmark) {
            return null;
        }
        if (!pasteboards.containsKey(bookmark)) {
            pasteboards.put(bookmark, new PathPasteboard(bookmark));
        }
        return pasteboards.get(bookmark);
    }

    public static List<PathPasteboard> allPasteboards() {
        return new ArrayList<PathPasteboard>(pasteboards.values());
    }

    public static void delete(Host bookmark) {
        if (pasteboards.containsKey(bookmark)) {
            pasteboards.get(bookmark).clear();
        }
        pasteboards.remove(bookmark);
    }
}

