/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.features;

import ch.cyberduck.core.exception.BackgroundException;
import java.util.Objects;

public interface Quota {
    public static final Space unknown = new Space(0L, Long.MAX_VALUE);

    public Space get() throws BackgroundException;

    public static final class Space {
        public final Long used;
        public final Long available;

        public Space(Long used, Long available) {
            this.used = used;
            this.available = available;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Space{");
            sb.append("used=").append(this.used);
            sb.append(", available=").append(this.available);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Space)) {
                return false;
            }
            Space space = (Space)o;
            return Objects.equals(this.used, space.used) && Objects.equals(this.available, space.available);
        }

        public int hashCode() {
            return Objects.hash(this.used, this.available);
        }
    }
}

