/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.Transfer;
import org.apache.log4j.Logger;

public class DefaultEditorListener
implements FileWatcherListener {
    private static final Logger log = Logger.getLogger(DefaultEditorListener.class);
    private final Controller controller;
    private final SessionPool session;
    private final Editor editor;
    private final Listener listener;

    public DefaultEditorListener(Controller controller, SessionPool session, Editor editor, Listener listener) {
        this.controller = controller;
        this.session = session;
        this.editor = editor;
        this.listener = listener;
    }

    @Override
    public void fileWritten(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("File %s written", file));
        }
        this.controller.background(new WorkerBackgroundAction<Transfer>(this.controller, this.session, this.editor.save(new DisabledTransferErrorCallback())){

            @Override
            public void cleanup() {
                super.cleanup();
                DefaultEditorListener.this.listener.saved();
            }
        });
    }

    @Override
    public void fileDeleted(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("File %s deleted", file));
        }
        this.editor.close();
    }

    @Override
    public void fileCreated(Local file) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("File %s created", file));
        }
        this.controller.background(new WorkerBackgroundAction<Transfer>(this.controller, this.session, this.editor.save(new DisabledTransferErrorCallback())){

            @Override
            public void cleanup() {
                super.cleanup();
                DefaultEditorListener.this.listener.saved();
            }
        });
    }

    public static interface Listener {
        public void saved();
    }
}

