/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class DefaultUserDateFormatter
extends AbstractUserDateFormatter {
    private final String tz;

    public DefaultUserDateFormatter(String tz) {
        this.tz = tz;
    }

    @Override
    public String getShortFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return LocaleFactory.localizedString("Unknown");
        }
        DateFormat format = SimpleDateFormat.getDateTimeInstance(3, 3);
        format.setTimeZone(TimeZone.getTimeZone(this.tz));
        return format.format(milliseconds);
    }

    @Override
    public String getMediumFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return LocaleFactory.localizedString("Unknown");
        }
        DateFormat format = SimpleDateFormat.getDateTimeInstance(2, 2);
        format.setTimeZone(TimeZone.getTimeZone(this.tz));
        return format.format(milliseconds);
    }

    @Override
    public String getLongFormat(long milliseconds, boolean natural) {
        if (-1L == milliseconds) {
            return LocaleFactory.localizedString("Unknown");
        }
        DateFormat format = SimpleDateFormat.getDateTimeInstance(0, 0);
        format.setTimeZone(TimeZone.getTimeZone(this.tz));
        return format.format(milliseconds);
    }
}

