/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.date.DateFormatter;
import ch.cyberduck.core.date.InvalidDateException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDateFormatter
implements DateFormatter {
    private final DateFormat format;

    protected AbstractDateFormatter(DateFormat format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(Date input, TimeZone zone) {
        DateFormat dateFormat = this.format;
        synchronized (dateFormat) {
            this.format.setTimeZone(zone);
            return this.format.format(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(long milliseconds, TimeZone zone) {
        DateFormat dateFormat = this.format;
        synchronized (dateFormat) {
            this.format.setTimeZone(zone);
            return this.format.format(milliseconds);
        }
    }

    @Override
    public Date parse(String input) throws InvalidDateException {
        if (StringUtils.isBlank((CharSequence)input)) {
            throw new InvalidDateException();
        }
        DateFormat dateFormat = this.format;
        synchronized (dateFormat) {
            try {
                return this.format.parse(input);
            }
            catch (ParseException e) {
                throw new InvalidDateException(e.getMessage(), e);
            }
        }
    }
}

