/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.cache.LRUCache;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReverseLookupCache<T extends Referenceable>
implements Cache<T> {
    private static final Logger log = Logger.getLogger(ReverseLookupCache.class);
    private final Cache<T> proxy;
    private final LRUCache<CacheReference, Referenceable> reverse;
    private final Referenceable MISSING_ITEM = new Referenceable(){};

    public ReverseLookupCache(Cache<T> proxy, int size) {
        this.proxy = proxy;
        this.reverse = size == Integer.MAX_VALUE ? LRUCache.usingLoader(this::load) : LRUCache.usingLoader(this::load, size);
    }

    private Referenceable load(CacheReference key) {
        T value = this.proxy.lookup(key);
        if (null == value) {
            return this.MISSING_ITEM;
        }
        return value;
    }

    @Override
    public CacheReference<?> reference(T object) {
        return this.proxy.reference(object);
    }

    @Override
    public boolean isCached(T parent) {
        return this.proxy.isCached(parent);
    }

    @Override
    public boolean isEmpty() {
        return this.proxy.isEmpty();
    }

    @Override
    public boolean isValid(T item) {
        return this.proxy.isValid(item);
    }

    @Override
    public AttributedList<T> put(T reference, AttributedList<T> children) {
        for (Referenceable f : children) {
            this.reverse.put(this.proxy.reference(f), f);
        }
        return this.proxy.put(reference, children);
    }

    @Override
    public AttributedList<T> get(T parent) {
        return this.proxy.get(parent);
    }

    @Override
    public T lookup(CacheReference reference) {
        Referenceable value = this.reverse.get(reference);
        if (this.MISSING_ITEM == value) {
            log.warn((Object)String.format("Lookup failed for %s in reverse cache", reference));
            return null;
        }
        return (T)value;
    }

    @Override
    public AttributedList<T> remove(T reference) {
        AttributedList<T> removed = this.proxy.remove(reference);
        for (Referenceable r : removed) {
            this.reverse.remove(this.proxy.reference(r));
        }
        return removed;
    }

    @Override
    public Map<T, AttributedList<T>> asMap() {
        return this.proxy.asMap();
    }

    @Override
    public long size() {
        return this.proxy.size();
    }

    @Override
    public void invalidate(T parent) {
        this.proxy.invalidate(parent);
    }

    @Override
    public void clear() {
        this.proxy.clear();
        this.reverse.clear();
    }
}

