/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.ExternalSecurityProviderLoader;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.exception.MantaClientEncryptionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public final class SecretKeyUtils {
    private SecretKeyUtils() {
    }

    public static SecretKey generate(SupportedCipherDetails cipherDetails) {
        try {
            return SecretKeyUtils.generate(cipherDetails.getKeyGenerationAlgorithm(), cipherDetails.getKeyLengthBits());
        }
        catch (NoSuchAlgorithmException e) {
            String msg = String.format("Couldn't find algorithm [%s]", cipherDetails.getCipherAlgorithm());
            throw new MantaClientEncryptionException(msg, e);
        }
    }

    public static SecretKey generate(String algorithm, int bits) throws NoSuchAlgorithmException {
        Validate.notNull((Object)algorithm, (String)"Cipher must not be null", (Object[])new Object[0]);
        Validate.isTrue((bits > 0 ? 1 : 0) != 0, (String)"Cipher bits must be greater than zero", (Object[])new Object[0]);
        KeyGenerator symKeyGenerator = KeyGenerator.getInstance(algorithm, ExternalSecurityProviderLoader.getPreferredProvider());
        symKeyGenerator.init(bits);
        return symKeyGenerator.generateKey();
    }

    public static void writeKey(SecretKey key, OutputStream out) throws IOException {
        Validate.notNull((Object)key, (String)"Key must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)out, (String)"OutputStream must not be null", (Object[])new Object[0]);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key.getEncoded());
        out.write(x509EncodedKeySpec.getEncoded());
    }

    public static void writeKeyToPath(SecretKey key, Path path) throws IOException {
        Validate.notNull((Object)key, (String)"Key must not be null", (Object[])new Object[0]);
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            SecretKeyUtils.writeKey(key, out);
        }
    }

    public static SecretKeySpec loadKey(byte[] bytes, SupportedCipherDetails cipherDetails) {
        Validate.notNull((Object)bytes, (String)"Byte array must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)cipherDetails, (String)"Cipher details must not be null", (Object[])new Object[0]);
        return new SecretKeySpec(bytes, cipherDetails.getKeyGenerationAlgorithm());
    }

    public static SecretKeySpec loadKey(InputStream in, String algorithm) throws NoSuchAlgorithmException, IOException {
        Validate.notNull((Object)in, (String)"InputStream must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)algorithm, (String)"Cipher must not be null", (Object[])new Object[0]);
        byte[] bytesAsEncodedKey = IOUtils.toByteArray((InputStream)in);
        return new SecretKeySpec(bytesAsEncodedKey, algorithm);
    }

    public static SecretKeySpec loadKeyFromPath(Path path, String algorithm) throws NoSuchAlgorithmException, IOException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            SecretKeySpec secretKeySpec = SecretKeyUtils.loadKey(in, algorithm);
            return secretKeySpec;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SecretKeySpec loadKeyFromPath(Path path, SupportedCipherDetails cipherDetails) throws IOException {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            SecretKeySpec secretKeySpec = SecretKeyUtils.loadKey(in, cipherDetails.getKeyGenerationAlgorithm());
            return secretKeySpec;
        }
        catch (NoSuchAlgorithmException e) {
            String msg = String.format("Couldn't find algorithm [%s]", cipherDetails.getKeyGenerationAlgorithm());
            throw new MantaClientEncryptionException(msg, e);
        }
    }
}

