/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaErrorCode;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecursiveDirectoryCreationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveDirectoryCreationStrategy.class);

    private RecursiveDirectoryCreationStrategy() {
    }

    static long createWithSkipDepth(MantaClient client, String rawPath, MantaHttpHeaders headers, int skipDepth) throws IOException {
        String[] paths = MantaUtils.writeablePrefixPaths(rawPath);
        if (paths.length <= skipDepth) {
            return RecursiveDirectoryCreationStrategy.createCompletely(client, rawPath, headers);
        }
        String assumedExistingDirectory = paths[skipDepth - 1];
        String maybeNewDirectory = paths[skipDepth];
        LOG.debug("ASSUME {}", (Object)assumedExistingDirectory);
        Boolean redundantPut = RecursiveDirectoryCreationStrategy.createNewDirectory(client, maybeNewDirectory, headers, rawPath);
        long ops = 1L;
        if (redundantPut == null) {
            LOG.debug("FAILED {}", (Object)maybeNewDirectory);
            return ops + RecursiveDirectoryCreationStrategy.createCompletely(client, rawPath, headers);
        }
        for (int idx = skipDepth + 1; idx < paths.length; ++idx) {
            client.putDirectory(paths[idx], headers);
            ++ops;
        }
        return ops;
    }

    static long createCompletely(MantaClient client, String rawPath, MantaHttpHeaders headers) throws IOException {
        long ops = 0L;
        for (String path : MantaUtils.writeablePrefixPaths(rawPath)) {
            client.putDirectory(path, headers);
            ++ops;
        }
        return ops;
    }

    private static Boolean createNewDirectory(MantaClient client, String path, MantaHttpHeaders headers, String targetPath) throws IOException {
        try {
            return client.putDirectory(path, headers);
        }
        catch (MantaClientHttpResponseException mchre) {
            if (mchre.getServerCode().equals((Object)MantaErrorCode.DIRECTORY_DOES_NOT_EXIST_ERROR)) {
                return null;
            }
            mchre.setContextValue("recursiveDirectoryCreationTarget", targetPath);
            throw mchre;
        }
    }
}

