/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaObjectResponse
implements MantaObject {
    private static final long serialVersionUID = 2752480890369898121L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaObjectResponse.class);
    public static final String DIRECTORY_RESPONSE_CONTENT_TYPE = "application/x-json-stream; type=directory";
    public static final String PATTERN_ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final String[] DATETIME_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSX", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private String path;
    private Long contentLength;
    private String etag;
    private String mtime;
    private String type;
    private String requestId;
    private MantaHttpHeaders httpHeaders;
    private MantaMetadata metadata;

    public MantaObjectResponse() {
    }

    public MantaObjectResponse(String path) {
        Validate.notBlank((CharSequence)path, (String)"Path must not be blank", (Object[])new Object[0]);
        this.path = path;
        this.httpHeaders = new MantaHttpHeaders();
    }

    public MantaObjectResponse(String path, MantaHttpHeaders headers) {
        this(path, headers, new MantaMetadata(headers.metadataAsStrings()));
    }

    public MantaObjectResponse(String path, MantaHttpHeaders headers, MantaMetadata metadata) {
        String contentType;
        Validate.notBlank((CharSequence)path, (String)"Path must be not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)headers, (String)"Headers must not be null", (Object[])new Object[0]);
        this.path = path;
        this.httpHeaders = headers;
        this.contentLength = headers.getContentLength();
        this.etag = headers.getETag();
        this.mtime = headers.getLastModified();
        this.requestId = headers.getRequestId();
        this.type = headers.getContentType() != null ? ((contentType = headers.getContentType()) == null ? null : (contentType.equals(DIRECTORY_RESPONSE_CONTENT_TYPE) ? "directory" : "object")) : null;
        this.metadata = metadata != null ? metadata : new MantaMetadata(headers.metadataAsStrings());
    }

    @Override
    public final String getPath() {
        return MantaUtils.decodePath(this.path);
    }

    public final void setPath(String path) {
        this.path = path;
    }

    @Override
    public final Long getContentLength() {
        return this.contentLength;
    }

    MantaObjectResponse setContentLength(Long length) {
        this.contentLength = length;
        if (this.getHttpHeaders() != null) {
            this.getHttpHeaders().setContentLength(length);
        }
        return this;
    }

    @Override
    public final String getContentType() {
        String contentType = null;
        if (this.getHttpHeaders() != null) {
            contentType = this.getHttpHeaders().getContentType();
        }
        return contentType;
    }

    public MantaObjectResponse setContentType(String contentType) {
        if (this.getHttpHeaders() != null) {
            this.getHttpHeaders().setContentType(contentType);
        }
        return this;
    }

    @Override
    public final String getEtag() {
        return this.etag;
    }

    @Override
    public byte[] getMd5Bytes() {
        if (this.getHttpHeaders() != null) {
            String encoded = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getHttpHeaders().getFirstHeaderStringValue("computed-md5"), this.getHttpHeaders().getContentMD5()});
            return Base64.decodeBase64((String)encoded);
        }
        return null;
    }

    @Override
    public final String getMtime() {
        return this.mtime;
    }

    public void setMtime(String mtime) {
        this.mtime = mtime;
    }

    @Override
    public Date getLastModifiedTime() {
        String lastModified;
        if (this.getMtime() != null) {
            lastModified = this.getMtime();
        } else if (this.getHttpHeaders() != null && this.getHttpHeaders().getLastModified() != null) {
            lastModified = this.getHttpHeaders().getLastModified();
        } else {
            return null;
        }
        Date parsed = DateUtils.parseDate((String)lastModified, (String[])DATETIME_FORMATS);
        if (parsed == null) {
            LOGGER.warn("Error parsing mtime value [{}] with formats: {}", (Object)lastModified, (Object)DATETIME_FORMATS);
        }
        return parsed;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public final MantaHttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public final Object getHeader(String fieldName) {
        return this.httpHeaders.get(fieldName);
    }

    @Override
    public String getHeaderAsString(String fieldName) {
        return this.httpHeaders.getAsString(fieldName);
    }

    @Override
    public MantaMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final boolean isDirectory() {
        return "directory".equals(this.type);
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MantaObjectResponse) {
            MantaObjectResponse that = (MantaObjectResponse)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.getContentLength(), that.getContentLength()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getEtag(), that.getEtag()) && Objects.equals(this.getMtime(), that.getMtime()) && Objects.equals(this.httpHeaders, that.httpHeaders);
        }
        if (o instanceof MantaObject) {
            MantaObject that = (MantaObject)o;
            return Objects.equals(this.getContentLength(), that.getContentLength()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getEtag(), that.getEtag()) && Objects.equals(this.getMtime(), that.getMtime());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getContentLength(), this.getContentType(), this.getEtag(), this.getMtime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('{');
        sb.append("path='").append(this.path).append('\'');
        sb.append(", contentLength=").append(this.getContentLength());
        sb.append(", contentType='").append(this.getContentType()).append('\'');
        sb.append(", etag='").append(this.getEtag()).append('\'');
        sb.append(", mtime='").append(this.getMtime()).append('\'');
        sb.append(", type='").append(this.getType()).append('\'');
        sb.append(", requestId='").append(this.getRequestId()).append('\'');
        sb.append(", httpHeaders=").append(this.httpHeaders);
        sb.append(", directory=").append(this.isDirectory());
        sb.append('}');
        return sb.toString();
    }
}

