/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaResourceCloseException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.http.entity.EmbeddedHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.output.ClosedOutputStream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantaObjectOutputStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaObjectOutputStream.class);
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("manta-outputstream");
    private static final long CLOSED_CHECK_INTERVAL = 50L;
    private static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            String msg = String.format("An error occurred in the reading thread [%s] when attempting to write to an object via an OutputStream.", t.getName());
            LOGGER.error(msg, e);
        }
    };
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable runnable) {
            String name = String.format("stream-%d", this.count.getAndIncrement());
            Thread thread = new Thread(THREAD_GROUP, runnable, name);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
            return thread;
        }
    };
    public static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(THREAD_FACTORY);
    private final EmbeddedHttpContent httpContent;
    private final Future<MantaObjectResponse> completed;
    private MantaObjectResponse objectResponse;
    private AtomicLong bytesWritten = new AtomicLong(0L);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final String path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MantaObjectOutputStream(String path, HttpHelper httpHelper, MantaHttpHeaders mantaHttpHeaders, MantaMetadata metadata, ContentType contentType) {
        this.httpContent = new EmbeddedHttpContent(contentType.toString(), this.closed);
        this.path = path;
        MantaHttpHeaders headers = mantaHttpHeaders == null ? new MantaHttpHeaders() : mantaHttpHeaders;
        if (contentType != null) {
            headers.setContentType(contentType.toString());
        }
        this.completed = EXECUTOR.submit(() -> httpHelper.httpPut(path, headers, this.httpContent, metadata));
        EmbeddedHttpContent embeddedHttpContent = this.httpContent;
        synchronized (embeddedHttpContent) {
            while (this.httpContent.getWriter() == null && !this.isClosed()) {
                try {
                    this.httpContent.wait(50L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed()) {
            MantaIOException e = new MantaIOException("Can't write to a closed stream");
            e.setContextValue("path", this.path);
            throw e;
        }
        this.httpContent.getWriter().write(b);
        this.bytesWritten.incrementAndGet();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.isClosed()) {
            MantaIOException e = new MantaIOException("Can't write to a closed stream");
            e.setContextValue("path", this.path);
            throw e;
        }
        this.httpContent.getWriter().write(b);
        this.bytesWritten.addAndGet(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed()) {
            MantaIOException e = new MantaIOException("Can't write to a closed stream");
            e.setContextValue("path", this.path);
            throw e;
        }
        this.httpContent.getWriter().write(b, off, len);
        this.bytesWritten.addAndGet(b.length);
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.httpContent.getWriter().flush();
    }

    protected static Boolean isInnerStreamClosed(OutputStream stream) {
        OutputStream inner = MantaObjectOutputStream.findMostInnerOutputStream(stream);
        if (inner.getClass().equals(ClosedOutputStream.class)) {
            return true;
        }
        try {
            Field f = FieldUtils.getField(inner.getClass(), (String)"closed", (boolean)true);
            if (f == null) {
                throw new IllegalArgumentException("FieldUtils.getField(inner.getClass()) returned null");
            }
            Object result = f.get(inner);
            return (boolean)((Boolean)result);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
            String msg = String.format("Error finding [closed] field on class: %s", inner.getClass());
            LOGGER.warn(msg, (Throwable)e);
            return null;
        }
    }

    protected static OutputStream findMostInnerOutputStream(OutputStream stream) {
        Field f = FieldUtils.getField(stream.getClass(), (String)"out", (boolean)true);
        if (f == null) {
            return stream;
        }
        try {
            Object result = f.get(stream);
            if (result instanceof OutputStream) {
                return MantaObjectOutputStream.findMostInnerOutputStream((OutputStream)result);
            }
            return stream;
        }
        catch (IllegalAccessException e) {
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        this.closed.compareAndSet(false, true);
        Boolean innerIsClosed = MantaObjectOutputStream.isInnerStreamClosed(this.httpContent.getWriter());
        if (innerIsClosed != null && !innerIsClosed.booleanValue()) {
            this.httpContent.getWriter().flush();
        }
        try {
            this.httpContent.close();
        }
        catch (RuntimeException e22) {
            String msg = "Problem closing HTTP content stream";
            throw new MantaResourceCloseException(msg, e22);
        }
        EmbeddedHttpContent e22 = this.httpContent;
        synchronized (e22) {
            this.httpContent.notify();
        }
        try {
            this.objectResponse = this.completed.get();
            this.objectResponse.setContentLength(this.bytesWritten.longValue());
        }
        catch (InterruptedException e22) {
        }
        catch (ExecutionException e) {
            String requestId;
            MantaIOException mioe = new MantaIOException("An exception was thrown within the thread writing to the network socket", e.getCause());
            if (this.objectResponse != null && (requestId = this.objectResponse.getHeaderAsString("x-request-id")) != null) {
                mioe.addContextValue("requestId", requestId);
            }
            mioe.addContextValue("path", this.path);
            throw mioe;
        }
    }

    public boolean isClosed() {
        if (!this.closed.get()) {
            return this.closed.get();
        }
        Boolean innerClosed = this.httpContent != null && this.httpContent.getWriter() != null ? MantaObjectOutputStream.isInnerStreamClosed(this.httpContent.getWriter()) : Boolean.valueOf(false);
        if (BooleanUtils.toBoolean((Boolean)innerClosed)) {
            return this.closed.compareAndSet(false, innerClosed);
        }
        return this.closed.get();
    }

    public MantaObjectResponse getObjectResponse() {
        return this.objectResponse;
    }
}

