/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.AsciiRandomStringService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphLockFeature
implements Lock<String> {
    private final GraphSession session;

    public GraphLockFeature(GraphSession session) {
        this.session = session;
    }

    public String lock(Path file) throws BackgroundException {
        try {
            Files.checkout((DriveItem)this.session.toItem(file));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to checkout file {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
        return new AsciiRandomStringService().random();
    }

    public void unlock(Path file, String token) throws BackgroundException {
        try {
            Files.checkin((DriveItem)this.session.toItem(file), (String)String.format("%s-%s", PreferencesFactory.get().getProperty("application.name"), new AlphanumericRandomStringService().random()));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to check in file {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }
}

