/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FileLocksApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileLock;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileLockRequest;
import org.joda.time.DateTime;

public class StoregateLockFeature
implements Lock<String> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateLockFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public String lock(Path file) throws BackgroundException {
        try {
            FileLockRequest request = new FileLockRequest();
            request.setExpire(new DateTime().plusMillis(PreferencesFactory.get().getInteger("storegate.lock.ttl")));
            request.setOwner(this.session.getHost().getCredentials().getUsername());
            FileLock lock = new FileLocksApi((ApiClient)this.session.getClient()).fileLocksCreateLock(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), request);
            return lock.getLockId();
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public void unlock(Path file, String token) throws BackgroundException {
        try {
            new FileLocksApi((ApiClient)this.session.getClient()).fileLocksDeleteLock(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), token);
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

