/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2FileidProvider
implements IdProvider {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private Cache<Path> cache = PathCache.empty();

    public B2FileidProvider(B2Session session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList list;
        Path found;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)found.attributes().getVersionId())) {
            return this.set(file, found.attributes().getVersionId());
        }
        try {
            if (this.containerService.isContainer(file)) {
                B2BucketResponse info = ((B2ApiClient)this.session.getClient()).listBucket(file.getName());
                return this.set(file, info.getBucketId());
            }
            if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)found.attributes().getVersionId())) {
                return this.set(file, found.attributes().getVersionId());
            }
            B2ListFilesResponse response = ((B2ApiClient)this.session.getClient()).listFileNames(this.getFileid(this.containerService.getContainer(file), listener), this.containerService.getKey(file), Integer.valueOf(2));
            for (B2FileInfoResponse info : response.getFiles()) {
                if (!StringUtils.equals((CharSequence)this.containerService.getKey(file), (CharSequence)info.getFileName())) continue;
                return this.set(file, info.getFileId());
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected String set(Path file, String id) {
        file.attributes().setVersionId(id);
        return id;
    }

    public B2FileidProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

