/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.log4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.perf4j.LoggingStopWatch;

public class Log4JStopWatch
extends LoggingStopWatch {
    private transient Logger logger;
    private Level normalPriority;
    private Level exceptionPriority;

    public Log4JStopWatch() {
        this("", null, Logger.getLogger((String)"org.perf4j.TimingLogger"), Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(Logger logger) {
        this("", null, logger, Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(Logger logger, Level normalPriority) {
        this("", null, logger, normalPriority, Level.WARN);
    }

    public Log4JStopWatch(Logger logger, Level normalPriority, Level exceptionPriority) {
        this("", null, logger, normalPriority, exceptionPriority);
    }

    public Log4JStopWatch(String tag) {
        this(tag, null, Logger.getLogger((String)"org.perf4j.TimingLogger"), Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(String tag, Logger logger) {
        this(tag, null, logger, Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(String tag, Logger logger, Level normalPriority) {
        this(tag, null, logger, normalPriority, Level.WARN);
    }

    public Log4JStopWatch(String tag, Logger logger, Level normalPriority, Level exceptionPriority) {
        this(tag, null, logger, normalPriority, exceptionPriority);
    }

    public Log4JStopWatch(String tag, String message) {
        this(tag, message, Logger.getLogger((String)"org.perf4j.TimingLogger"), Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(String tag, String message, Logger logger) {
        this(tag, message, logger, Level.INFO, Level.WARN);
    }

    public Log4JStopWatch(String tag, String message, Logger logger, Level normalPriority) {
        this(tag, message, logger, normalPriority, Level.WARN);
    }

    public Log4JStopWatch(String tag, String message, Logger logger, Level normalPriority, Level exceptionPriority) {
        this(System.currentTimeMillis(), -1L, tag, message, logger, normalPriority, exceptionPriority);
    }

    public Log4JStopWatch(long startTime, long elapsedTime, String tag, String message, Logger logger, Level normalPriority, Level exceptionPriority) {
        super(startTime, elapsedTime, tag, message);
        this.logger = logger;
        this.normalPriority = normalPriority;
        this.exceptionPriority = exceptionPriority;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Level getNormalPriority() {
        return this.normalPriority;
    }

    public void setNormalPriority(Level normalPriority) {
        this.normalPriority = normalPriority;
    }

    public Level getExceptionPriority() {
        return this.exceptionPriority;
    }

    public void setExceptionPriority(Level exceptionPriority) {
        this.exceptionPriority = exceptionPriority;
    }

    public boolean isLogging() {
        return this.logger.isEnabledFor((Priority)this.normalPriority);
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        this.logger.log((Priority)(exception == null ? this.normalPriority : this.exceptionPriority), (Object)stopWatchAsString, exception);
    }

    public Log4JStopWatch clone() {
        return (Log4JStopWatch)super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeUTF(this.logger.getName());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.logger = Logger.getLogger((String)stream.readUTF());
    }
}

