/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSReadFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptInputStream;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoUtils;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class TripleCryptReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(TripleCryptReadFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSReadFeature proxy;

    public TripleCryptReadFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSReadFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            FileKey key = new NodesApi((ApiClient)this.session.getClient()).requestUserFileKey(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), null, null);
            EncryptedFileKey encFileKey = TripleCryptConverter.toCryptoEncryptedFileKey(key);
            try {
                UserKeyPair userKeyPair = this.getUserKeyPair(encFileKey);
                PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)encFileKey, (UserPrivateKey)userKeyPair.getUserPrivateKey(), (String)this.unlock(callback, userKeyPair).getPassword());
                return new TripleCryptInputStream(this.proxy.read(file, status, callback), Crypto.createFileDecryptionCipher((PlainFileKey)plainFileKey), CryptoUtils.stringToByteArray((String)plainFileKey.getTag()));
            }
            catch (InvalidFileKeyException e) {
                log.warn((Object)String.format("Failure %s  decrypting file key for %s. Invalidate cache", new Object[]{e, file}));
                this.session.resetUserKeyPairs();
                UserKeyPair userKeyPair = this.getUserKeyPair(encFileKey);
                PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)encFileKey, (UserPrivateKey)userKeyPair.getUserPrivateKey(), (String)this.unlock(callback, userKeyPair).getPassword());
                return new TripleCryptInputStream(this.proxy.read(file, status, callback), Crypto.createFileDecryptionCipher((PlainFileKey)plainFileKey), CryptoUtils.stringToByteArray((String)plainFileKey.getTag()));
            }
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    private Credentials unlock(ConnectionCallback callback, UserKeyPair userKeyPair) throws CryptoException, BackgroundException {
        Credentials passphrase;
        try {
            passphrase = new TripleCryptKeyPair().unlock((PasswordCallback)callback, this.session.getHost(), userKeyPair);
        }
        catch (LoginCanceledException e) {
            throw new AccessDeniedException(LocaleFactory.localizedString((String)"Decryption password required", (String)"SDS"), (Throwable)e);
        }
        return passphrase;
    }

    private UserKeyPair getUserKeyPair(EncryptedFileKey encFileKey) throws BackgroundException, UnknownVersionException {
        UserKeyPairContainer keyPairContainer = this.session.getKeyPairForFileKey(encFileKey.getVersion());
        UserKeyPair userKeyPair = TripleCryptConverter.toCryptoUserKeyPair(keyPairContainer);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Attempt to unlock private key %s", userKeyPair.getUserPrivateKey()));
        }
        return userKeyPair;
    }

    public boolean offset(Path file) {
        return false;
    }
}

