/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Webhook information")
public class Webhook {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="secret")
    private String secret = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="eventTypeNames")
    private List<String> eventTypeNames = new ArrayList<String>();
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;
    @JsonProperty(value="failStatus")
    private Integer failStatus = null;

    public Webhook id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Webhook name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Webhook url(String url) {
        this.url = url;
        return this;
    }

    @Schema(required=true, description="URL")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Webhook secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Schema(description="Secret; used for event message signatures")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Webhook isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(required=true, description="Is enabled")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Webhook expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(required=true, description="Expiration date / time")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public Webhook eventTypeNames(List<String> eventTypeNames) {
        this.eventTypeNames = eventTypeNames;
        return this;
    }

    public Webhook addEventTypeNamesItem(String eventTypeNamesItem) {
        this.eventTypeNames.add(eventTypeNamesItem);
        return this;
    }

    @Schema(required=true, description="List of names of event types")
    public List<String> getEventTypeNames() {
        return this.eventTypeNames;
    }

    public void setEventTypeNames(List<String> eventTypeNames) {
        this.eventTypeNames = eventTypeNames;
    }

    public Webhook createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(required=true, description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Webhook createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public Webhook updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(required=true, description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Webhook updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Webhook failStatus(Integer failStatus) {
        this.failStatus = failStatus;
        return this;
    }

    @Schema(description="Last HTTP status code when a webhook is disabled due to delivery failures")
    public Integer getFailStatus() {
        return this.failStatus;
    }

    public void setFailStatus(Integer failStatus) {
        this.failStatus = failStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.id, webhook.id) && Objects.equals(this.name, webhook.name) && Objects.equals(this.url, webhook.url) && Objects.equals(this.secret, webhook.secret) && Objects.equals(this.isEnabled, webhook.isEnabled) && Objects.equals(this.expireAt, webhook.expireAt) && Objects.equals(this.eventTypeNames, webhook.eventTypeNames) && Objects.equals(this.createdAt, webhook.createdAt) && Objects.equals(this.createdBy, webhook.createdBy) && Objects.equals(this.updatedAt, webhook.updatedAt) && Objects.equals(this.updatedBy, webhook.updatedBy) && Objects.equals(this.failStatus, webhook.failStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.url, this.secret, this.isEnabled, this.expireAt, this.eventTypeNames, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.failStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    eventTypeNames: ").append(this.toIndentedString(this.eventTypeNames)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    failStatus: ").append(this.toIndentedString(this.failStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

