/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.types.GraphType;
import org.nuxeo.onedrive.client.types.ItemReference;

public class Permission
extends GraphType<Permission> {
    private String id;
    private OneDriveIdentitySet grantedTo;
    private List<OneDriveIdentitySet> grantedToIdentities;
    private ItemReference inheritedFrom;
    private OneDriveSharingLink link;
    private List<String> roles;
    private String shareId;
    private ZonedDateTime expirationDateTime;
    private Boolean hasPassword;

    public String getId() {
        return this.id;
    }

    public OneDriveIdentitySet getGrantedTo() {
        return this.grantedTo;
    }

    public List<OneDriveIdentitySet> getGrantedToIdentities() {
        return this.grantedToIdentities;
    }

    public ItemReference getInheritedFrom() {
        return this.inheritedFrom;
    }

    public OneDriveSharingLink getLink() {
        return this.link;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public String getShareId() {
        return this.shareId;
    }

    public ZonedDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public Boolean hasPassword() {
        return this.hasPassword;
    }

    @Override
    protected void parseMember(JsonObject.Member member) {
        switch (member.getName()) {
            case "id": {
                this.id = member.getValue().asString();
                break;
            }
            case "grantedTo": {
                this.grantedTo = new OneDriveIdentitySet(member.getValue().asObject());
                break;
            }
            case "grantedToIdentities": {
                this.grantedToIdentities = member.getValue().asArray().values().stream().map(i -> new OneDriveIdentitySet(i.asObject())).collect(Collectors.toList());
                break;
            }
            case "inheritedFrom": {
                this.inheritedFrom = (ItemReference)new ItemReference().fromJson(member.getValue().asObject());
                break;
            }
            case "invitation": {
                break;
            }
            case "link": {
                this.link = new OneDriveSharingLink(member.getValue().asObject());
                break;
            }
            case "roles": {
                this.roles = member.getValue().asArray().values().stream().map(JsonValue::asString).collect(Collectors.toList());
                break;
            }
            case "shareId": {
                this.shareId = member.getValue().asString();
                break;
            }
            case "expirationDateTime": {
                this.expirationDateTime = ZonedDateTime.parse(member.getValue().asString());
                break;
            }
            case "hasPassword": {
                this.hasPassword = member.getValue().asBoolean();
                break;
            }
            default: {
                super.parseMember(member);
            }
        }
    }
}

