/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AbstractListService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;

public class S3VersionedObjectListService
extends S3AbstractListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3VersionedObjectListService.class);
    public static final String KEY_DELETE_MARKER = "delete_marker";
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final Integer concurrency;
    private final boolean references;

    public S3VersionedObjectListService(S3Session session) {
        this(session, PreferencesFactory.get().getInteger("s3.listing.concurrency"), PreferencesFactory.get().getBoolean("s3.versioning.references.enable"));
    }

    public S3VersionedObjectListService(S3Session session, boolean references) {
        this(session, PreferencesFactory.get().getInteger("s3.listing.concurrency"), references);
    }

    public S3VersionedObjectListService(S3Session session, Integer concurrency, boolean references) {
        this.session = session;
        this.concurrency = concurrency;
        this.references = references;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"list", (int)this.concurrency);
        try {
            Object chunk;
            String prefix = this.createPrefix(directory);
            Path bucket = this.containerService.getContainer(directory);
            AttributedList children = new AttributedList();
            ArrayList<Future<Path>> folders = new ArrayList<Future<Path>>();
            String priorLastKey = null;
            String priorLastVersionId = null;
            long revision = 0L;
            String lastKey = null;
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                String[] stringArray;
                chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, false);
                for (BaseVersionOrDeleteMarker marker : chunk.getItems()) {
                    String key = PathNormalizer.normalize((String)URIEncoder.decode((String)marker.getKey()));
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    PathAttributes attributes = new PathAttributes();
                    attributes.setVersionId(marker.getVersionId());
                    if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                        revision = 0L;
                    }
                    attributes.setRevision(Long.valueOf(++revision));
                    attributes.setDuplicate(marker.isDeleteMarker() && marker.isLatest() || !marker.isLatest());
                    if (marker.isDeleteMarker()) {
                        attributes.setCustom(Collections.singletonMap(KEY_DELETE_MARKER, Boolean.TRUE.toString()));
                    }
                    attributes.setModificationDate(marker.getLastModified().getTime());
                    attributes.setRegion(bucket.attributes().getRegion());
                    if (marker instanceof S3Version) {
                        S3Version object = (S3Version)marker;
                        attributes.setSize(object.getSize());
                        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
                            attributes.setETag(object.getEtag());
                        }
                        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
                            attributes.setStorageClass(object.getStorageClass());
                        }
                    }
                    Path f = new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file), attributes);
                    if (this.references && attributes.isDuplicate()) {
                        Path latest = (Path)children.find((Predicate)((Object)new LatestVersionPathPredicate(f)));
                        if (latest != null) {
                            AttributedList versions = new AttributedList((Iterable)latest.attributes().getVersions());
                            versions.add((Referenceable)f);
                            latest.attributes().setVersions(versions);
                        } else {
                            log.warn((Object)String.format("No current version found for %s", f));
                        }
                    }
                    children.add((Referenceable)f);
                    lastKey = key;
                }
                for (String common2 : stringArray = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common2)) {
                        log.warn((Object)String.format("Skipping prefix %s", common2));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)URIEncoder.decode((String)common2));
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    folders.add(this.submit(pool, bucket, directory, URIEncoder.decode((String)common2)));
                }
                priorLastKey = null != chunk.getNextKeyMarker() ? URIEncoder.decode((String)chunk.getNextKeyMarker()) : null;
                priorLastVersionId = chunk.getNextVersionIdMarker();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            for (Future future : folders) {
                try {
                    children.add((Referenceable)((Path)future.get()));
                }
                catch (InterruptedException e) {
                    log.error((Object)"Listing versioned objects failed with interrupt failure");
                    throw new ConnectionCanceledException((Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn((Object)String.format("Listing versioned objects failed with execution failure %s", e.getMessage()));
                    if (e.getCause() instanceof BackgroundException) {
                        throw (BackgroundException)e.getCause();
                    }
                    throw new BackgroundException(e.getCause());
                }
            }
            listener.chunk(directory, children);
            if (!hasDirectoryPlaceholder && children.isEmpty()) {
                if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
                    throw new NotfoundException(directory.getAbsolute());
                }
                chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(PathNormalizer.name((String)URIEncoder.encode((String)bucket.getName())), String.format("%s%s", this.createPrefix(directory.getParent()), directory.getName()), String.valueOf('/'), 1L, null, null, false);
                if (Arrays.stream(chunk.getCommonPrefixes()).map(URIEncoder::decode).noneMatch(common -> common.equals(prefix))) {
                    throw new NotfoundException(directory.getAbsolute());
                }
            }
            AttributedList attributedList = children;
            return attributedList;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<Path> submit(ThreadPool pool, final Path bucket, final Path directory, final String common) {
        return pool.execute((Callable)new BackgroundExceptionCallable<Path>(){

            public Path call() throws BackgroundException {
                PathAttributes attributes = new PathAttributes();
                attributes.setRegion(bucket.attributes().getRegion());
                Path prefix = new Path(directory, PathNormalizer.name((String)common), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                try {
                    VersionOrDeleteMarkersChunk versions = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), common, null, 1L, null, null, false);
                    if (versions.getItems().length == 1) {
                        StorageObjectsChunk unversioned;
                        BaseVersionOrDeleteMarker version = versions.getItems()[0];
                        if (URIEncoder.decode((String)version.getKey()).equals(common)) {
                            attributes.setVersionId(version.getVersionId());
                            if (version.isDeleteMarker()) {
                                attributes.setCustom((Map)ImmutableMap.of((Object)S3VersionedObjectListService.KEY_DELETE_MARKER, (Object)Boolean.TRUE.toString()));
                            }
                        }
                        if ((unversioned = ((RequestEntityRestStorageService)((Object)S3VersionedObjectListService.this.session.getClient())).listObjectsChunked(bucket.getName(), common, null, 1L, null, false)).getObjects().length == 0) {
                            attributes.setDuplicate(true);
                        }
                    }
                    return prefix;
                }
                catch (ServiceException e) {
                    throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, prefix);
                }
            }
        });
    }

    public static final class LatestVersionPathPredicate
    extends SimplePathPredicate {
        public LatestVersionPathPredicate(Path f) {
            super(f);
        }

        public boolean test(Path test) {
            if (super.test(test)) {
                return !test.attributes().isDuplicate();
            }
            return false;
        }
    }
}

