/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.Base64;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSPasswordUtilities {
    public static final int WHEEL_LENGTH;
    public static final int VAL_0 = 48;
    public static final int VAL_A = 65;
    public static final int VAL_LC_A = 97;
    public static final int VAL_BANG = 33;
    public static final List<Integer> WHEEL;
    public static final String RAND_STRING = "1gCBizHWbwIYyWLoysGzTe6SyzqFKMniZX05faZHWAwQKXf6Fs";
    public static final String RAND_STRING_V2 = "A.ObfV2";
    public static final int MAX_PWD_LENGTH = 50;
    static final Logger log;

    public static String obfuscateIRODSPasswordForAdminPasswordChange(String newPassword, String adminPassword, String challengeValue) throws JargonException {
        log.info("obfuscateIRODSPasswordForAdminPasswordChange()");
        if (newPassword == null || newPassword.isEmpty()) {
            throw new IllegalArgumentException("null or empty newPassword");
        }
        if (adminPassword == null || adminPassword.isEmpty()) {
            throw new IllegalArgumentException("null or empty adminPassword");
        }
        if (challengeValue == null || challengeValue.isEmpty()) {
            throw new IllegalArgumentException("null or empty challengeValue");
        }
        int secs = Calendar.getInstance().get(14);
        secs &= 0x1F;
        StringBuilder myIn = new StringBuilder();
        myIn.append(RAND_STRING_V2);
        myIn.append(newPassword);
        StringBuilder myKey = new StringBuilder();
        myKey.append(adminPassword);
        myKey.append(challengeValue);
        String myKey2 = MiscIRODSUtils.computeMD5HashOfAStringValue(IRODSPasswordUtilities.pad(myKey.toString(), 100, '\u0000'));
        int firstCharOfMyIn = myIn.charAt(0);
        myIn.setCharAt(0, (char)(firstCharOfMyIn += secs));
        String obfuscatedValue = IRODSPasswordUtilities.obfuscateIRODSPasswordWithCypherChaining(myIn.toString(), myKey2);
        return obfuscatedValue;
    }

    public static String deriveHexSubsetOfChallenge(String challengeValue) {
        int subsetLength;
        if (challengeValue == null || challengeValue.isEmpty()) {
            throw new IllegalArgumentException("challengeValue is null or empty");
        }
        byte[] temp = Base64.fromString(challengeValue);
        if (temp.length < (subsetLength = 16)) {
            throw new IllegalArgumentException("challengeValue length is < 16");
        }
        byte[] subsetBytes = Arrays.copyOfRange(temp, 0, 16);
        return IRODSPasswordUtilities.getHexString(subsetBytes);
    }

    public static String obfEncodeByKey(String sourceData, String key, boolean pad) throws JargonException {
        MessageDigest messageDigest;
        if (sourceData == null || sourceData.isEmpty()) {
            throw new JargonException("newPassword is null or empty");
        }
        if (key == null || key.isEmpty()) {
            throw new JargonException("oldPassword is null or empty");
        }
        String randPaddedNewPassword = pad ? IRODSPasswordUtilities.padPasswordWithRandomStringData(sourceData) : sourceData;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("error getting MD5 MessageDigest", e);
        }
        byte[] oldPwdBuffer = new byte[100];
        byte[] oldPwdAsBytes = key.getBytes();
        for (int i = 0; i < key.length(); ++i) {
            oldPwdBuffer[i] = oldPwdAsBytes[i];
        }
        messageDigest.update(oldPwdBuffer);
        byte[] digestRound1 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound1:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound1));
        }
        messageDigest.reset();
        messageDigest.update(digestRound1);
        byte[] digestRound2 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound2:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound2));
        }
        byte[] concatRound1AndRound2 = new byte[digestRound1.length + digestRound2.length];
        int concatI = 0;
        for (byte by : digestRound1) {
            concatRound1AndRound2[concatI++] = by;
        }
        for (byte by : digestRound2) {
            concatRound1AndRound2[concatI++] = by;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound3 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound3:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound3));
        }
        byte[] concatRound1AndRound2AndRound3 = new byte[digestRound1.length + digestRound2.length + digestRound3.length];
        concatI = 0;
        for (byte by : digestRound1) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        for (byte by : digestRound2) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        for (byte by : digestRound3) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound4 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound4:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound4));
        }
        byte[] byArray = new byte[digestRound1.length + digestRound2.length + digestRound3.length + digestRound4.length];
        concatI = 0;
        for (byte element : digestRound1) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound2) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound3) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound4) {
            byArray[concatI++] = element;
        }
        if (log.isDebugEnabled()) {
            log.debug("cpKeyArray:{}", (Object)IRODSPasswordUtilities.getHexString(byArray));
        }
        boolean bl = false;
        String cpInArray = randPaddedNewPassword;
        int k = 0;
        boolean found = false;
        StringBuilder cpOut = new StringBuilder();
        for (int cpInIdx = 0; cpInIdx < cpInArray.length(); ++cpInIdx) {
            int n;
            k = 0;
            found = false;
            byte b = byArray[n++];
            k = IRODSPasswordUtilities.unsignedByteToInt(b);
            if (n > 60) {
                n = 0;
            }
            for (int i = 0; i < WHEEL_LENGTH; ++i) {
                int wheelVal;
                int cpInVal = IRODSPasswordUtilities.unsignedByteToInt(cpInArray.getBytes()[cpInIdx]);
                if (cpInVal != (wheelVal = WHEEL.get(i).intValue())) continue;
                int j = i + k;
                wheelVal = WHEEL.get(j %= WHEEL_LENGTH);
                char wheelChr = (char)wheelVal;
                cpOut.append(wheelChr);
                found = true;
                break;
            }
            if (found) continue;
            if (cpInIdx == cpInArray.length()) break;
            cpOut.append(cpInArray.charAt(cpInIdx));
        }
        return cpOut.toString();
    }

    public static String obfuscateIRODSPasswordWithCypherChaining(String newPassword, String oldPassword) throws JargonException {
        MessageDigest messageDigest;
        if (newPassword == null || newPassword.isEmpty()) {
            throw new JargonException("newPassword is null or empty");
        }
        if (oldPassword == null || oldPassword.isEmpty()) {
            throw new JargonException("oldPassword is null or empty");
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("error getting MD5 MessageDigest", e);
        }
        byte[] oldPwdBuffer = new byte[100];
        byte[] oldPwdAsBytes = oldPassword.getBytes();
        for (int i = 0; i < oldPassword.length(); ++i) {
            oldPwdBuffer[i] = oldPwdAsBytes[i];
        }
        messageDigest.update(oldPwdBuffer);
        byte[] digestRound1 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound1:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound1));
        }
        messageDigest.reset();
        messageDigest.update(digestRound1);
        byte[] digestRound2 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound2:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound2));
        }
        byte[] concatRound1AndRound2 = new byte[digestRound1.length + digestRound2.length];
        int concatI = 0;
        for (byte by : digestRound1) {
            concatRound1AndRound2[concatI++] = by;
        }
        for (byte by : digestRound2) {
            concatRound1AndRound2[concatI++] = by;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound3 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound3:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound3));
        }
        byte[] concatRound1AndRound2AndRound3 = new byte[digestRound1.length + digestRound2.length + digestRound3.length];
        concatI = 0;
        for (byte by : digestRound1) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        for (byte by : digestRound2) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        for (byte by : digestRound3) {
            concatRound1AndRound2AndRound3[concatI++] = by;
        }
        messageDigest.reset();
        messageDigest.update(concatRound1AndRound2);
        byte[] digestRound4 = messageDigest.digest();
        if (log.isDebugEnabled()) {
            log.debug("digestRound4:{}", (Object)IRODSPasswordUtilities.getHexString(digestRound4));
        }
        byte[] byArray = new byte[digestRound1.length + digestRound2.length + digestRound3.length + digestRound4.length];
        concatI = 0;
        for (byte element : digestRound1) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound2) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound3) {
            byArray[concatI++] = element;
        }
        for (byte element : digestRound4) {
            byArray[concatI++] = element;
        }
        if (log.isDebugEnabled()) {
            log.debug("cpKeyArray:{}", (Object)IRODSPasswordUtilities.getHexString(byArray));
        }
        boolean bl = false;
        String cpInArray = newPassword;
        int k = 0;
        boolean found = false;
        int prevChar = 0;
        StringBuilder cpOut = new StringBuilder();
        for (int cpInIdx = 0; cpInIdx < cpInArray.length(); ++cpInIdx) {
            int n;
            k = 0;
            found = false;
            byte b = byArray[n++];
            k = IRODSPasswordUtilities.unsignedByteToInt(b);
            if (n > 60) {
                n = 0;
            }
            for (int i = 0; i < WHEEL_LENGTH; ++i) {
                int wheelVal;
                int cpInVal = IRODSPasswordUtilities.unsignedByteToInt(cpInArray.getBytes()[cpInIdx]);
                if (cpInVal != (wheelVal = WHEEL.get(i).intValue())) continue;
                int j = i + k + prevChar;
                wheelVal = WHEEL.get(j %= WHEEL_LENGTH);
                char wheelChr = (char)wheelVal;
                cpOut.append(wheelChr);
                prevChar = wheelChr & 0xFF;
                found = true;
                break;
            }
            if (found) continue;
            if (cpInIdx == cpInArray.length()) break;
            cpOut.append(cpInArray.charAt(cpInIdx));
        }
        return cpOut.toString();
    }

    public static String padPasswordWithRandomStringData(String newPassword) {
        int lCopy = 40 - newPassword.length();
        StringBuilder pwdBuf = new StringBuilder();
        pwdBuf.append(newPassword);
        if (lCopy > 15) {
            pwdBuf.append(RAND_STRING.substring(0, lCopy));
        }
        String randPaddedNewPassword = pwdBuf.toString();
        return randPaddedNewPassword;
    }

    public static String getHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte element : b) {
            result.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static String getHexString2(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte element : b) {
            int asInt = IRODSPasswordUtilities.unsignedByteToInt(element);
            result.append(Integer.toHexString(asInt));
        }
        return result.toString();
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static String getHashedPassword(String passwordHashValue, IRODSAccount irodsAccount) throws JargonException {
        MessageDigest messageDigest;
        StringBuilder sb = new StringBuilder();
        sb.append(passwordHashValue);
        sb.append(irodsAccount.getPassword());
        String hashBuff = IRODSPasswordUtilities.pad(sb.toString(), 100, '\u0000');
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("error getting MD5 MessageDigest", e);
        }
        byte[] hashBytes = hashBuff.getBytes();
        messageDigest.update(hashBytes);
        byte[] digestRound1 = messageDigest.digest();
        String hexString = IRODSPasswordUtilities.getHexString(digestRound1);
        return hexString;
    }

    public static String pad(String str, int size, char padChar) {
        if (str.length() < size) {
            int i;
            char[] temp = new char[size];
            for (i = 0; i < str.length(); ++i) {
                temp[i] = str.charAt(i);
            }
            while (i < size) {
                temp[i] = padChar;
                ++i;
            }
            str = new String(temp);
        }
        return str;
    }

    static {
        int i;
        log = LoggerFactory.getLogger(IRODSPasswordUtilities.class);
        WHEEL = new ArrayList<Integer>();
        for (i = 0; i < 10; ++i) {
            WHEEL.add(48 + i);
        }
        for (i = 0; i < 26; ++i) {
            WHEEL.add(65 + i);
        }
        for (i = 0; i < 26; ++i) {
            WHEEL.add(97 + i);
        }
        for (i = 0; i < 15; ++i) {
            WHEEL.add(33 + i);
        }
        WHEEL_LENGTH = WHEEL.size();
    }
}

