/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.FileNotFoundException;
import org.irods.jargon.core.checksum.AbstractChecksumComputeStrategy;
import org.irods.jargon.core.checksum.ChecksumManager;
import org.irods.jargon.core.checksum.ChecksumManagerImpl;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.ChecksumInvalidException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectChecksumUtilitiesAOImpl
extends IRODSGenericAO
implements DataObjectChecksumUtilitiesAO {
    public static final Logger log = LoggerFactory.getLogger(DataObjectChecksumUtilitiesAOImpl.class);
    private final ChecksumManager checksumManager;
    private final CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO;

    public DataObjectChecksumUtilitiesAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.checksumManager = new ChecksumManagerImpl(irodsAccount, this.getIRODSAccessObjectFactory());
        this.collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(irodsAccount);
    }

    @Override
    public ChecksumValue retrieveExistingChecksumForDataObject(String irodsDataObjectAbsolutePath) throws org.irods.jargon.core.exception.FileNotFoundException, JargonException {
        log.info("retrieveChecksumForDataObject()");
        if (irodsDataObjectAbsolutePath == null || irodsDataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsDataObjectAbsolutePath");
        }
        log.info("irodsDataObjectAbsolutePath:{}", (Object)irodsDataObjectAbsolutePath);
        ObjStat objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsDataObjectAbsolutePath);
        return this.computeChecksumValueFromIrodsData(objStat.getChecksum());
    }

    @Override
    public ChecksumValue computeChecksumOnDataObject(IRODSFile irodsFile) throws JargonException {
        log.info("computeChecksumOnDataObject()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        log.info("computing checksum on irodsFile: {}", (Object)irodsFile.getAbsolutePath());
        DataObjInp dataObjInp = DataObjInp.instanceForDataObjectChecksum(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (response == null) {
            log.error("invalid response to checksum call, response was null, expected checksum value");
            throw new JargonException("invalid response to checksum call, received null response when doing checksum on file:" + irodsFile);
        }
        String returnedChecksum = response.getTag("myStr").getStringValue();
        log.info("checksum is: {}", (Object)returnedChecksum);
        return this.computeChecksumValueFromIrodsData(returnedChecksum);
    }

    @Override
    public ChecksumValue computeChecksumValueFromIrodsData(String irodsValue) throws JargonException {
        return this.checksumManager.determineChecksumEncodingFromIrodsData(irodsValue.trim());
    }

    @Override
    public ChecksumValue verifyLocalFileAgainstIrodsFileChecksum(String localAbsolutePath, String irodsAbsolutePath) throws org.irods.jargon.core.exception.FileNotFoundException, ChecksumInvalidException, JargonException {
        ChecksumValue localValue;
        log.info("verifyLocalFileAgainstIrodsFileChecksum()");
        if (localAbsolutePath == null || localAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty localAbsolutePath");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        log.info("localAbsolutePath:{}", (Object)localAbsolutePath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        File localFile = new File(localAbsolutePath);
        if (!localFile.exists()) {
            throw new org.irods.jargon.core.exception.FileNotFoundException("local file does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("local file is not a file, it is a collection");
        }
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsAbsolutePath);
        if (!irodsFile.exists()) {
            throw new org.irods.jargon.core.exception.FileNotFoundException("irods file does not exist");
        }
        if (!irodsFile.isFile()) {
            throw new JargonException("irods file is not a file, it is a collection");
        }
        ChecksumValue checksumValue = this.computeChecksumOnDataObject(irodsFile);
        AbstractChecksumComputeStrategy checksumComputeStrategy = this.getIRODSSession().getLocalChecksumComputerFactory().instance(checksumValue.getChecksumEncoding());
        try {
            localValue = checksumComputeStrategy.computeChecksumValueForLocalFile(localAbsolutePath);
        }
        catch (FileNotFoundException e) {
            throw new org.irods.jargon.core.exception.FileNotFoundException("local file not found during checksum");
        }
        if (!localValue.equals(checksumValue)) {
            log.error("checksum mismatch");
            log.error("local checksum:{}", (Object)localValue);
            log.error("irods checksum:{}", (Object)checksumValue);
            throw new ChecksumInvalidException("checksum mismatch between local and iRODS");
        }
        return checksumValue;
    }
}

