/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.auth;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.auth.AgentAuthenticator;
import ch.cyberduck.core.threading.CancelCallback;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.apache.log4j.Logger;

public class SFTPAgentAuthentication
implements AuthenticationProvider<Boolean> {
    private static final Logger log = Logger.getLogger(SFTPAgentAuthentication.class);
    private final SSHClient client;
    private final AgentAuthenticator agent;

    public SFTPAgentAuthentication(SSHClient client, AgentAuthenticator agent) {
        this.client = client;
        this.agent = agent;
    }

    public Boolean authenticate(Host bookmark, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Login using agent %s for %s", this.agent, bookmark));
        }
        for (Identity identity : this.agent.getIdentities()) {
            try {
                this.client.auth(bookmark.getCredentials().getUsername(), new AuthMethod[]{new AuthAgent(this.agent.getProxy(), identity)});
                break;
            }
            catch (UserAuthException e) {
                cancel.verify();
            }
            catch (Buffer.BufferException e) {
                throw new DefaultIOExceptionMappingService().map((IOException)((Object)e));
            }
            catch (TransportException e) {
                throw new SFTPExceptionMappingService().map((IOException)((Object)e));
            }
        }
        return this.client.isAuthenticated();
    }

    public String getMethod() {
        return "publickey";
    }
}

