/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.blobstrategy;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.AllocateJobChunkSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.AllocateJobChunkSpectraS3Response;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.StrategyUtils;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.AbstractBlobStrategy;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryBehavior;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutSequentialBlobStrategy
extends AbstractBlobStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PutSequentialBlobStrategy.class);
    private final Iterator<Objects> chunksThatContainBlobs;

    public PutSequentialBlobStrategy(Ds3Client client, MasterObjectList masterObjectList, EventDispatcher eventDispatcher, ChunkAttemptRetryBehavior retryBehavior, ChunkAttemptRetryDelayBehavior chunkAttemptRetryDelayBehavior) {
        super(client, masterObjectList, eventDispatcher, retryBehavior, chunkAttemptRetryDelayBehavior);
        this.chunksThatContainBlobs = StrategyUtils.filterChunks(masterObjectList.getObjects()).iterator();
    }

    @Override
    public Iterable<JobPart> getWork() throws IOException, InterruptedException {
        Objects nextChunk = this.allocateChunk(this.chunksThatContainBlobs.next());
        return FluentIterable.from(nextChunk.getObjects()).filter(input -> input.getInCache() == false).transform((Function)new Function<BulkObject, JobPart>(){

            @Nullable
            public JobPart apply(@Nullable BulkObject blob) {
                return new JobPart(PutSequentialBlobStrategy.this.client(), blob);
            }
        });
    }

    private Objects allocateChunk(Objects filtered) throws IOException {
        Objects chunk = null;
        while (chunk == null) {
            chunk = this.tryAllocateChunk(filtered);
        }
        return chunk;
    }

    private Objects tryAllocateChunk(Objects filtered) throws IOException {
        AllocateJobChunkSpectraS3Response response = this.client().allocateJobChunkSpectraS3(new AllocateJobChunkSpectraS3Request(filtered.getChunkId().toString()));
        LOG.info("AllocatedJobChunkResponse status: {}", (Object)response.getStatus().toString());
        switch (response.getStatus()) {
            case ALLOCATED: {
                this.retryBehavior().reset();
                return response.getObjectsResult();
            }
            case RETRYLATER: {
                this.retryBehavior().invoke();
                try {
                    this.chunkAttemptRetryDelayBehavior().delay(response.getRetryAfterSeconds());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        }
        assert (false) : "This line of code should be impossible to hit.";
        return null;
    }

    @Override
    public void blobCompleted(BulkObject bulkObject) {
    }
}

