/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.JobNode;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.models.common.Range;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrategyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StrategyUtils.class);

    public static ImmutableMap<UUID, JobNode> buildNodeMap(Iterable<JobNode> nodes) {
        ImmutableMap.Builder nodeMap = ImmutableMap.builder();
        for (JobNode node : nodes) {
            nodeMap.put((Object)node.getId(), (Object)node);
        }
        return nodeMap.build();
    }

    public static ImmutableList<Objects> filterChunks(Iterable<Objects> chunks) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Objects chunk : chunks) {
            Objects filteredChunk = StrategyUtils.filterChunk(chunk);
            if (filteredChunk.getObjects().size() <= 0) continue;
            builder.add((Object)filteredChunk);
        }
        return builder.build();
    }

    private static Objects filterChunk(Objects chunk) {
        Objects newChunk = new Objects();
        newChunk.setChunkId(chunk.getChunkId());
        newChunk.setChunkNumber(chunk.getChunkNumber());
        newChunk.setNodeId(chunk.getNodeId());
        newChunk.setObjects((List<BulkObject>)StrategyUtils.filterObjects(chunk.getObjects()));
        return newChunk;
    }

    private static ImmutableList<BulkObject> filterObjects(List<BulkObject> blobs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BulkObject blob : blobs) {
            if (blob.getInCache().booleanValue()) continue;
            builder.add((Object)blob);
        }
        return builder.build();
    }

    public static ImmutableCollection<Range> getRangesForBlob(ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> rangesForBlobs, BulkObject blob) {
        ImmutableMultimap rangesForBlob = (ImmutableMultimap)rangesForBlobs.get((Object)blob.getName());
        if (rangesForBlob != null) {
            return rangesForBlob.get((Object)blob);
        }
        return null;
    }
}

