/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Quiesced;
import com.spectralogic.ds3client.models.TargetReadPreferenceType;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyAzureTargetSpectraS3Request
extends AbstractRequest {
    private final String azureTarget;
    private String accountKey;
    private String accountName;
    private Integer autoVerifyFrequencyInDays;
    private String cloudBucketPrefix;
    private String cloudBucketSuffix;
    private TargetReadPreferenceType defaultReadPreference;
    private boolean https;
    private String name;
    private boolean permitGoingOutOfSync;
    private Quiesced quiesced;

    public ModifyAzureTargetSpectraS3Request(String azureTarget) {
        this.azureTarget = azureTarget;
    }

    public ModifyAzureTargetSpectraS3Request withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        this.updateQueryParam("account_key", accountKey);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withAccountName(String accountName) {
        this.accountName = accountName;
        this.updateQueryParam("account_name", accountName);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withAutoVerifyFrequencyInDays(Integer autoVerifyFrequencyInDays) {
        this.autoVerifyFrequencyInDays = autoVerifyFrequencyInDays;
        this.updateQueryParam("auto_verify_frequency_in_days", autoVerifyFrequencyInDays);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withCloudBucketPrefix(String cloudBucketPrefix) {
        this.cloudBucketPrefix = cloudBucketPrefix;
        this.updateQueryParam("cloud_bucket_prefix", cloudBucketPrefix);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withCloudBucketSuffix(String cloudBucketSuffix) {
        this.cloudBucketSuffix = cloudBucketSuffix;
        this.updateQueryParam("cloud_bucket_suffix", cloudBucketSuffix);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withDefaultReadPreference(TargetReadPreferenceType defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
        this.updateQueryParam("default_read_preference", defaultReadPreference);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withHttps(boolean https) {
        this.https = https;
        this.updateQueryParam("https", https);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withPermitGoingOutOfSync(boolean permitGoingOutOfSync) {
        this.permitGoingOutOfSync = permitGoingOutOfSync;
        this.updateQueryParam("permit_going_out_of_sync", permitGoingOutOfSync);
        return this;
    }

    public ModifyAzureTargetSpectraS3Request withQuiesced(Quiesced quiesced) {
        this.quiesced = quiesced;
        this.updateQueryParam("quiesced", quiesced);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_target/" + this.azureTarget;
    }

    public String getAzureTarget() {
        return this.azureTarget;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public Integer getAutoVerifyFrequencyInDays() {
        return this.autoVerifyFrequencyInDays;
    }

    public String getCloudBucketPrefix() {
        return this.cloudBucketPrefix;
    }

    public String getCloudBucketSuffix() {
        return this.cloudBucketSuffix;
    }

    public TargetReadPreferenceType getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public boolean getHttps() {
        return this.https;
    }

    public String getName() {
        return this.name;
    }

    public boolean getPermitGoingOutOfSync() {
        return this.permitGoingOutOfSync;
    }

    public Quiesced getQuiesced() {
        return this.quiesced;
    }
}

